/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.directorywalker.DirectoryScanner;
import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.SuffixFilter;
import com.thoughtworks.qdox.model.AbstractInheritableJavaEntity;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IAnnotationTransformer;
import org.testng.internal.annotations.ITest;
import org.testng.internal.annotations.JDK14TagFactory;
import org.testng.log4testng.Logger;

public class JDK14AnnotationFinder
implements IAnnotationFinder {
    private static final Logger LOGGER = Logger.getLogger(JDK14AnnotationFinder.class);
    private Map<String, List<File>> m_sourceFiles = new HashMap<String, List<File>>();
    private Map<String, String> m_parsedClasses = new HashMap<String, String>();
    private Map<String, String> m_parsedFiles = new HashMap<String, String>();
    private JDK14TagFactory m_tagFactory = new JDK14TagFactory();
    private JavaDocBuilder m_docBuilder = new JavaDocBuilder();
    private String[] m_dirPaths;
    private IAnnotationTransformer m_transformer;

    public JDK14AnnotationFinder(IAnnotationTransformer transformer) {
        this.m_transformer = transformer;
    }

    public void addSourceDirs(String[] dirPaths) {
        if (dirPaths == null) {
            Utils.log(this.getClass().getName(), 1, "[WARNING] Array of source directory paths is null");
            return;
        }
        this.m_dirPaths = dirPaths;
        for (int i = 0; i < this.m_dirPaths.length; ++i) {
            File dir2 = new File(this.m_dirPaths[i]);
            DirectoryScanner scanner = new DirectoryScanner(dir2);
            scanner.addFilter(new SuffixFilter(".java"));
            scanner.scan(new FileVisitor(){

                public void visitFile(File currentFile) {
                    JDK14AnnotationFinder.this.registerSourceFile(currentFile);
                }
            });
        }
    }

    private void registerSourceFile(File sourcefile) {
        List<File> files = this.m_sourceFiles.get(sourcefile.getName());
        if (null == files) {
            files = new ArrayList<File>();
            this.m_sourceFiles.put(sourcefile.getName(), files);
        }
        files.add(sourcefile);
    }

    private boolean addSource(String filePath) {
        if (this.m_parsedFiles.containsKey(filePath)) {
            return true;
        }
        try {
            this.m_docBuilder.addSource(new FileReader(filePath));
            this.m_parsedFiles.put(filePath, filePath);
            return true;
        }
        catch (FileNotFoundException fnfe) {
            Utils.log(this.getClass().getName(), 1, "[WARNING] source file not found: " + filePath + "\n    " + fnfe.getMessage());
        }
        catch (Throwable t) {
            Utils.log(this.getClass().getName(), 1, "[WARNING] cannot parse source: " + filePath + "\n    " + t.getMessage());
        }
        return false;
    }

    private synchronized JavaClass getClassByName(Class clazz) {
        if (this.m_parsedClasses.containsKey(clazz.getName())) {
            JavaClass jc = this.m_docBuilder.getClassByName(clazz.getName());
            return jc;
        }
        this.parseSource(clazz);
        return this.getClassByName(clazz);
    }

    private synchronized void parseSource(Class clazz) {
        String className = clazz.getName();
        int innerSignPos = className.indexOf(36);
        String fileName = innerSignPos == -1 ? className.substring(className.lastIndexOf(46) + 1) : clazz.getName().substring(className.lastIndexOf(46) + 1, innerSignPos);
        List<File> sourcefiles = this.m_sourceFiles.get(fileName + ".java");
        if (null != sourcefiles) {
            for (File f : sourcefiles) {
                this.addSource(f.getAbsolutePath());
            }
        }
        this.m_parsedClasses.put(className, className);
        Class superClass = clazz.getSuperclass();
        if (null != superClass && !Object.class.equals(superClass)) {
            this.parseSource(superClass);
        }
    }

    public IAnnotation findAnnotation(Class cls, Class annotationClass) {
        if (Object.class.equals((Object)cls)) {
            return null;
        }
        IAnnotation result = this.m_tagFactory.createTag(annotationClass, this.getClassByName(cls), this.m_transformer);
        this.transform(result, cls, null, null);
        return result;
    }

    public IAnnotation findAnnotation(Method m, Class annotationClass) {
        IAnnotation result = this.findMethodAnnotation(m.getName(), m.getParameterTypes(), m.getDeclaringClass(), annotationClass, this.m_transformer);
        this.transform(result, null, null, m);
        return result;
    }

    public IAnnotation findAnnotation(Constructor m, Class annotationClass) {
        String name = this.stripPackage(m.getName());
        IAnnotation result = this.findMethodAnnotation(name, m.getParameterTypes(), m.getDeclaringClass(), annotationClass, this.m_transformer);
        this.transform(result, null, m, null);
        return result;
    }

    private void transform(IAnnotation a, Class testClass, Constructor testConstructor, Method testMethod) {
        if (a instanceof ITest) {
            this.m_transformer.transform((ITest)a, testClass, testConstructor, testMethod);
        }
    }

    private String stripPackage(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private IAnnotation findMethodAnnotation(String methodName, Class[] parameterTypes, Class methodClass, Class annotationClass, IAnnotationTransformer transformer) {
        if (Object.class.equals((Object)methodClass)) {
            return null;
        }
        IAnnotation result = null;
        JavaClass jc = this.getClassByName(methodClass);
        if (jc != null) {
            ArrayList<JavaMethod> methods = new ArrayList<JavaMethod>();
            JavaMethod[] allMethods = jc.getMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                JavaMethod jm = allMethods[i];
                if (!this.methodsAreEqual(jm, methodName, parameterTypes)) continue;
                methods.add(jm);
            }
            JavaMethod method = null;
            if (methods.size() > 0) {
                method = (JavaMethod)methods.get(0);
                result = this.findTag(annotationClass, result, method, transformer);
            }
        } else {
            Utils.log(this.getClass().getName(), 1, "[WARNING] cannot resolve class: " + methodClass.getName());
        }
        return result;
    }

    private boolean methodsAreEqual(JavaMethod jm, String methodName, Class[] parameterTypes) {
        boolean result = jm.getName().equals(methodName) && jm.getParameters().length == parameterTypes.length;
        return result;
    }

    private IAnnotation findTag(Class annotationClass, IAnnotation result, AbstractInheritableJavaEntity entity, IAnnotationTransformer transformer) {
        return this.m_tagFactory.createTag(annotationClass, entity, transformer);
    }

    private static void ppp(String s) {
        System.out.println("[JDK14AnnotationFinder] " + s);
    }
}

