/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import org.testng.internal.Utils;
import org.testng.internal.version.VersionInfo;
import org.testng.log4testng.Logger;

public final class AnnotationTypeEnum {
    private static final Logger LOGGER = Logger.getLogger(AnnotationTypeEnum.class);
    private static final String JDK_ANNOTATION_TYPE = "JDK";
    private static final String JAVADOC_ANNOTATION_TYPE = "javadoc";
    public static final AnnotationTypeEnum JAVADOC = new AnnotationTypeEnum("javadoc");
    public static final AnnotationTypeEnum JDK = new AnnotationTypeEnum("JDK");
    private String m_name;

    public static AnnotationTypeEnum valueOf(String pAnnotationType) {
        return AnnotationTypeEnum.valueOf(pAnnotationType, true);
    }

    public static AnnotationTypeEnum valueOf(String pAnnotationType, boolean strict) {
        AnnotationTypeEnum annotationType;
        if (pAnnotationType == null) {
            throw new IllegalArgumentException("annotation is null");
        }
        if (pAnnotationType.equals(JAVADOC_ANNOTATION_TYPE)) {
            annotationType = JAVADOC;
        } else if (pAnnotationType.equals(JDK_ANNOTATION_TYPE)) {
            annotationType = JDK;
        } else if (pAnnotationType.equals("1.4") || pAnnotationType.toLowerCase().equals(JAVADOC_ANNOTATION_TYPE.toLowerCase())) {
            annotationType = JAVADOC;
            AnnotationTypeEnum.log(2, pAnnotationType, annotationType);
        } else if ("1.5".equals(pAnnotationType) || pAnnotationType.toLowerCase().equals(JDK_ANNOTATION_TYPE.toLowerCase())) {
            annotationType = JDK;
            AnnotationTypeEnum.log(2, pAnnotationType, annotationType);
        } else if ("jdk1.5".equals(pAnnotationType.toLowerCase()) || "jdk5".equals(pAnnotationType.toLowerCase())) {
            annotationType = JDK;
            AnnotationTypeEnum.log(2, pAnnotationType, annotationType);
        } else {
            annotationType = VersionInfo.getDefaultAnnotationType();
            AnnotationTypeEnum.log(1, pAnnotationType, annotationType);
        }
        if (strict) {
            // empty if block
        }
        return annotationType;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.m_name;
    }

    private static void log(int level, String pAnnotationType, AnnotationTypeEnum pDefault) {
        String msg = "Illegal annotation type '" + pAnnotationType + "' defaulting to '" + pDefault + "'";
        LOGGER.info(msg);
        Utils.log("AnnotationTypeEnum", level, "[WARN] " + msg);
    }

    private AnnotationTypeEnum(String pName) {
        this.m_name = pName;
    }
}

