/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice;

import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.webservice.WebServiceClientDeployment;

public class WebServiceClientHandler {
    private static final Logger log = Logger.getLogger(WebServiceClientHandler.class);

    public static void setupServiceRefEnvironment(Context envCtx, Iterator serviceRefs, DeploymentInfo di) throws DeploymentException {
        WebServiceClientDeployment wsClientDeployment;
        if (!serviceRefs.hasNext()) {
            return;
        }
        MBeanServer server = MBeanServerLocator.locateJBoss();
        ObjectName jbosswsObjectName = ObjectNameFactory.create("jboss.ws:service=WebServiceClientDeployer");
        ObjectName objectName = null;
        try {
            if (!server.isRegistered(jbosswsObjectName)) {
                log.warn("No web service client deployer registered");
                return;
            }
            objectName = jbosswsObjectName;
            wsClientDeployment = (WebServiceClientDeployment)MBeanProxyExt.create(WebServiceClientDeployment.class, jbosswsObjectName, server);
        }
        catch (Exception e) {
            throw new DeploymentException("Cannot create proxy to the web service client deployer: " + objectName, e);
        }
        wsClientDeployment.setupServiceRefEnvironment(envCtx, serviceRefs, di);
    }
}

