/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.classloading;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.classloading.spi.ClassLoadingDomain;
import org.jboss.classloading.spi.DomainClassLoader;
import org.jboss.logging.Logger;
import org.jboss.vfs.classloading.SecurityActions;
import org.jboss.vfs.spi.ReadOnlyVFS;
import org.jboss.vfs.spi.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSClassLoader
extends SecureClassLoader
implements DomainClassLoader {
    private static Logger log = Logger.getLogger(VFSClassLoader.class);
    protected ArrayList<ClassPathVFS> classpath = new ArrayList();

    public VFSClassLoader(String[] searchCtxs, ReadOnlyVFS vfs) {
        String[] resolvedCtxs = searchCtxs;
        try {
            resolvedCtxs = this.resolveSearchCtxs(searchCtxs, vfs);
        }
        catch (IOException e) {
            log.warn("Failed to resolve searchCtxs", e);
        }
        ClassPathVFS cp = new ClassPathVFS(resolvedCtxs, vfs);
        this.classpath.add(cp);
    }

    public VFSClassLoader(String[] searchCtxs, ReadOnlyVFS vfs, ClassLoader parent) {
        super(parent);
        String[] resolvedCtxs = searchCtxs;
        try {
            resolvedCtxs = this.resolveSearchCtxs(searchCtxs, vfs);
        }
        catch (IOException e) {
            log.warn("Failed to resolve searchCtxs", e);
        }
        ClassPathVFS cp = new ClassPathVFS(resolvedCtxs, vfs);
        this.classpath.add(cp);
    }

    @Override
    public URL[] getClasspath() {
        ArrayList<URL> cp = new ArrayList<URL>(this.classpath.size());
        for (ClassPathVFS entry : this.classpath) {
            URL baseURL = entry.vfs.getRootURL();
            for (String path : entry.searchCtxs) {
                try {
                    URL entryURL = new URL(baseURL, path);
                    cp.add(entryURL);
                }
                catch (MalformedURLException e) {}
            }
        }
        URL[] theClasspath = new URL[cp.size()];
        cp.toArray(theClasspath);
        return theClasspath;
    }

    @Override
    public String[] getPackageNames() {
        return null;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String resName = name.replace('.', '/');
        VirtualFile classFile = this.findResourceFile(resName + ".class");
        if (classFile == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            int length;
            byte[] tmp = new byte[128];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = classFile.openStream();
            while ((length = is.read(tmp)) > 0) {
                baos.write(tmp, 0, length);
            }
            is.close();
            tmp = baos.toByteArray();
            ProtectionDomain pd = this.getProtectionDomain(classFile);
            Class<?> c = super.defineClass(name, tmp, 0, tmp.length, pd);
            return c;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Override
    public URL findResource(String name) {
        URL res;
        block3: {
            res = null;
            VirtualFile vf = this.findResourceFile(name);
            if (vf != null) {
                try {
                    res = vf.toURL();
                }
                catch (IOException e) {
                    if (!log.isTraceEnabled()) break block3;
                    log.trace("Failed to obtain vf URL: " + vf, e);
                }
            }
        }
        return res;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Vector resources = new Vector();
        return resources.elements();
    }

    @Override
    public Enumeration<URL> findResourcesLocally(String name) throws IOException {
        return this.findResources(name);
    }

    @Override
    public ClassLoadingDomain getDomain() {
        return null;
    }

    @Override
    public void setDomain(ClassLoadingDomain domain) {
    }

    @Override
    public Class loadClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        return this.findClass(name);
    }

    @Override
    public URL loadResourceLocally(String name) {
        return this.findResource(name);
    }

    @Override
    public Package[] getPackages() {
        return super.getPackages();
    }

    @Override
    public Package getPackage(String name) {
        return super.getPackage(name);
    }

    protected VirtualFile findResourceFile(String name) {
        VirtualFile vf;
        block3: {
            vf = null;
            try {
                ClassPathVFS cp;
                Iterator<ClassPathVFS> i$ = this.classpath.iterator();
                while (i$.hasNext() && (vf = (cp = i$.next()).vfs.resolveFile(name, cp.searchCtxs)) == null) {
                }
            }
            catch (IOException e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("Failed to find resource: " + name, e);
            }
        }
        return vf;
    }

    protected ProtectionDomain getProtectionDomain(VirtualFile classFile) throws MalformedURLException {
        Certificate[] certs = null;
        URL codesourceUrl = classFile.toURL();
        CodeSource cs = new CodeSource(codesourceUrl, certs);
        PermissionCollection permissions = SecurityActions.getPolicy().getPermissions(cs);
        if (log.isTraceEnabled()) {
            log.trace("getProtectionDomain, url=" + codesourceUrl + " codeSource=" + cs + " permissions=" + permissions);
        }
        return new ProtectionDomain(cs, permissions);
    }

    protected String[] resolveSearchCtxs(String[] searchCtxs, ReadOnlyVFS vfs) throws IOException {
        ArrayList<String> tmp = new ArrayList<String>(searchCtxs.length);
        for (String ctx : searchCtxs) {
            if (ctx.endsWith("*.jar")) {
                int slash = ctx.lastIndexOf(47);
                String dir = "";
                if (slash > 0) {
                    dir = ctx.substring(0, slash);
                }
                VirtualFile dirFile = vfs.resolveFile(dir);
                VirtualFile[] children = dirFile.getChildren();
                StringBuilder sb = new StringBuilder(dir);
                sb.append('/');
                int dirLength = sb.length();
                for (VirtualFile child : children) {
                    String name = child.getName();
                    if (!name.endsWith(".jar")) continue;
                    sb.append(name);
                    String path = sb.toString();
                    tmp.add(path);
                    sb.setLength(dirLength);
                }
                continue;
            }
            tmp.add(ctx);
        }
        log.debug("Resolved searchCtxs to: " + tmp);
        String[] newCtxs = new String[tmp.size()];
        tmp.toArray(newCtxs);
        return newCtxs;
    }

    protected static class ClassPathVFS {
        private ArrayList<String> searchCtxs = new ArrayList();
        private ReadOnlyVFS vfs;

        protected ClassPathVFS(String[] searchCtxs, ReadOnlyVFS vfs) {
            this.searchCtxs.addAll(Arrays.asList(searchCtxs));
            this.vfs = vfs;
        }
    }
}

