/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import com.sun.xacml.Indenter;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.Subject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.jacc.PolicyContext;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SimplePrincipal;

public class EJBXACMLUtil {
    private static Logger log = Logger.getLogger(EJBXACMLUtil.class);
    private boolean trace = log.isTraceEnabled();

    public RequestCtx createXACMLRequest(String ejbName, String methodName, Principal principal, AuthorizationManager authzManager) throws Exception {
        String action = methodName;
        RequestCtx requestCtx = null;
        String username = this.getUserName();
        Set roles = authzManager.getUserRoles(principal);
        URI subjectAttrUri = new URI("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
        Attribute subjectAttr = new Attribute(subjectAttrUri, null, null, (AttributeValue)new StringAttribute(username));
        HashSet<Attribute> subjectAttrSet = new HashSet<Attribute>();
        subjectAttrSet.add(subjectAttr);
        subjectAttrSet.addAll(this.getXACMLRoleSet(roles));
        HashSet<Subject> subjectSet = new HashSet<Subject>();
        subjectSet.add(new Subject(subjectAttrSet));
        URI resourceUri = new URI("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
        Attribute resourceAttr = new Attribute(resourceUri, null, null, (AttributeValue)new StringAttribute(ejbName));
        HashSet<Attribute> resourceSet = new HashSet<Attribute>();
        resourceSet.add(resourceAttr);
        HashSet<Attribute> actionSet = new HashSet<Attribute>();
        actionSet.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:action:action-id"), null, null, (AttributeValue)new StringAttribute(action)));
        HashSet<Attribute> environSet = new HashSet<Attribute>();
        URI currentTimeUri = new URI("urn:oasis:names:tc:xacml:1.0:environment:current-time");
        Attribute currentTimeAttr = new Attribute(currentTimeUri, null, null, (AttributeValue)new TimeAttribute());
        environSet.add(currentTimeAttr);
        requestCtx = new RequestCtx(subjectSet, resourceSet, actionSet, environSet);
        if (this.trace) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            requestCtx.encode((OutputStream)baos, new Indenter());
            log.trace("XACML Request:" + baos.toString());
            baos.close();
        }
        return requestCtx;
    }

    private Set getXACMLRoleSet(Set roles) throws Exception {
        Iterator iter;
        URI roleURI = new URI("urn:oasis:names:tc:xacml:2.0:example:attribute:role");
        HashSet<Attribute> roleset = new HashSet<Attribute>();
        Iterator iterator = iter = roles != null ? roles.iterator() : null;
        while (iter != null && iter.hasNext()) {
            Principal role = (Principal)iter.next();
            if (!(role instanceof SimplePrincipal)) continue;
            SimplePrincipal sp = (SimplePrincipal)role;
            Attribute roleAttr = new Attribute(roleURI, null, null, (AttributeValue)new StringAttribute(sp.getName()));
            roleset.add(roleAttr);
        }
        return roleset;
    }

    private String getUserName() throws Exception {
        String user = "";
        String key = "javax.security.auth.Subject.container";
        javax.security.auth.Subject caller = (javax.security.auth.Subject)PolicyContext.getContext(key);
        Iterator<Principal> iter = caller.getPrincipals().iterator();
        while (iter.hasNext()) {
            Principal p = iter.next();
            if (!(p instanceof SimplePrincipal) || p instanceof Group) continue;
            SimplePrincipal sp = (SimplePrincipal)p;
            user = sp.getName();
        }
        return user;
    }
}

