/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.config;

import org.jboss.logging.Logger;
import org.jboss.security.auth.login.LoginConfigObjectModelFactory;
import org.jboss.security.auth.login.ModuleOption;
import org.jboss.security.authorization.config.AuthorizationConfigEntryHolder;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class SecurityConfigObjectModelFactory
extends LoginConfigObjectModelFactory {
    private static Logger log = Logger.getLogger(SecurityConfigObjectModelFactory.class);
    private boolean trace = log.isTraceEnabled();

    public Object newChild(ApplicationPolicy aPolicy, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        Object child = super.newChild(aPolicy, navigator, namespaceUri, localName, attrs);
        if (child == null && "authorization".equals(localName)) {
            child = new AuthorizationInfo(aPolicy.getName());
        } else if (child == null && "rolemapping".equals(localName)) {
            MappingInfo mi = new MappingInfo();
            mi.setName(aPolicy.getName());
            child = mi;
        }
        return child;
    }

    public Object newChild(AuthorizationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        AuthorizationModuleEntry child = null;
        if (this.trace) {
            log.trace("newChild.AuthorizationInfo, localName: " + localName);
        }
        if ("policy-module".equals(localName)) {
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties(code.trim());
            String flag = attrs.getValue("flag");
            flag = (flag = StringPropertyReplacer.replaceProperties(flag.trim())) == null ? "REQUIRED" : flag.toUpperCase();
            AuthorizationModuleEntry entry = new AuthorizationModuleEntry(code);
            if ("REQUIRED".equals(flag)) {
                entry.setControlFlag(AuthorizationModuleEntry.ControlFlag.REQUIRED);
            } else if ("REQUISITE".equals(flag)) {
                entry.setControlFlag(AuthorizationModuleEntry.ControlFlag.REQUISITE);
            } else if ("SUFFICIENT".equals(flag)) {
                entry.setControlFlag(AuthorizationModuleEntry.ControlFlag.SUFFICIENT);
            } else {
                entry.setControlFlag(AuthorizationModuleEntry.ControlFlag.OPTIONAL);
            }
            child = entry;
            if (this.trace) {
                log.trace("newChild.AuthorizationInfo, policy-module code: " + code);
            }
        }
        return child;
    }

    public Object newChild(AuthorizationModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace("newChild.AppConfigurationEntryHolder, localName: " + localName);
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace("newChild.AuthModuleEntry, module-option name: " + name);
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, AuthorizationInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setAuthorizationInfo(authInfo);
        if (this.trace) {
            log.trace("addChild.ApplicationPolicy, name: " + aPolicy.getName());
        }
    }

    public void addChild(AuthorizationInfo authInfo, AuthorizationConfigEntryHolder entryInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        AuthorizationModuleEntry entry = entryInfo.getEntry();
        authInfo.add(entry);
        if (this.trace) {
            log.trace("addChild.AuthorizationInfo, name: " + entry.getPolicyModuleName());
        }
    }

    public void addChild(AuthorizationConfigEntryHolder entryInfo, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entryInfo.addOption(option);
        if (this.trace) {
            log.trace("addChild.AuthorizationConfigEntryHolder, name: " + option.getName());
        }
    }

    public void addChild(AuthorizationInfo authInfo, AuthorizationModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        authInfo.add(entry);
    }

    public void addChild(AuthorizationModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.add(option);
        if (this.trace) {
            log.trace("addChild.AuthorizationModuleEntry, name: " + option.getName());
        }
    }

    public Object newChild(MappingInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        MappingModuleEntry child = null;
        if (this.trace) {
            log.trace("newChild.RoleMappingInfo, localName: " + localName);
        }
        if ("mapping-module".equals(localName)) {
            MappingModuleEntry entry;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties(code.trim());
            child = entry = new MappingModuleEntry(code);
            if (this.trace) {
                log.trace("newChild.RoleMappingInfo, mapping-module code: " + code);
            }
        }
        return child;
    }

    public Object newChild(MappingModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace("newChild.AppConfigurationEntryHolder, localName: " + localName);
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace("newChild.AuthModuleEntry, module-option name: " + name);
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, MappingInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setRoleMappingInfo(authInfo);
        if (this.trace) {
            log.trace("addChild.ApplicationPolicy, name: " + aPolicy.getName());
        }
    }

    public void addChild(MappingModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.add(option);
        if (this.trace) {
            log.trace("addChild.AuthorizationModuleEntry, name: " + option.getName());
        }
    }

    public void addChild(MappingInfo authInfo, MappingModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        authInfo.add(entry);
    }
}

