/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.jboss.resource.adapter.jdbc.WrappedStatement;

public class WrappedResultSet
implements ResultSet {
    private WrappedStatement statement;
    private ResultSet resultSet;
    private boolean closed = false;
    private Object lock = new Object();

    public WrappedResultSet(WrappedStatement statement, ResultSet resultSet) {
        if (statement == null) {
            throw new IllegalArgumentException("Null statement!");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("Null result set!");
        }
        this.statement = statement;
        this.resultSet = resultSet;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof WrappedResultSet) {
            return this.resultSet.equals(((WrappedResultSet)o).resultSet);
        }
        if (o instanceof ResultSet) {
            return this.resultSet.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.resultSet.hashCode();
    }

    public String toString() {
        return this.resultSet.toString();
    }

    public ResultSet getUnderlyingResultSet() throws SQLException {
        this.checkState();
        return this.resultSet;
    }

    public boolean absolute(int row) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.absolute(row);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void afterLast() throws SQLException {
        this.checkState();
        try {
            this.resultSet.afterLast();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkState();
        try {
            this.resultSet.beforeFirst();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkState();
        try {
            this.resultSet.cancelRowUpdates();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkState();
        try {
            this.resultSet.clearWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.statement.unregisterResultSet(this);
        this.internalClose();
    }

    public void deleteRow() throws SQLException {
        this.checkState();
        try {
            this.resultSet.deleteRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int findColumn(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.findColumn(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean first() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.first();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Array getArray(int i) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getArray(i);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Array getArray(String colName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getArray(colName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getAsciiStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getAsciiStream(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBigDecimal(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBigDecimal(columnIndex, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBigDecimal(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBigDecimal(columnName, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBinaryStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBinaryStream(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Blob getBlob(int i) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBlob(i);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Blob getBlob(String colName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBlob(colName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBoolean(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean getBoolean(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBoolean(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getByte(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public byte getByte(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getByte(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBytes(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public byte[] getBytes(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getBytes(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getCharacterStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getCharacterStream(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Clob getClob(int i) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getClob(i);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Clob getClob(String colName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getClob(colName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getConcurrency() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getConcurrency();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public String getCursorName() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getCursorName();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Date getDate(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getDate(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getDate(columnIndex, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Date getDate(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getDate(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getDate(columnName, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getDouble(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public double getDouble(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getDouble(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getFetchDirection() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getFetchDirection();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getFetchSize();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getFloat(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public float getFloat(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getFloat(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getInt(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getInt(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getInt(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getInt(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public long getLong(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getLong(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public long getLong(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getLong(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getMetaData();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getObject(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getObject(i, map);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Object getObject(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getObject(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Object getObject(String colName, Map map) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getObject(colName, map);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Ref getRef(int i) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getRef(i);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Ref getRef(String colName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getRef(colName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getRow() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public short getShort(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getShort(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public short getShort(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getShort(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Statement getStatement() throws SQLException {
        this.checkState();
        return this.statement;
    }

    public String getString(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getString(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public String getString(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getString(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Time getTime(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getTime(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getTime(columnIndex, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Time getTime(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getTime(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getTime(columnName, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getTimestamp(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getTimestamp(columnIndex, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getTimestamp(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getTimestamp(columnName, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getType() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getType();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getUnicodeStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        try {
            return this.resultSet.getUnicodeStream(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public URL getURL(int columnIndex) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getURL(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public URL getURL(String columnName) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getURL(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.getWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void insertRow() throws SQLException {
        this.checkState();
        try {
            this.resultSet.insertRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean isAfterLast() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.isAfterLast();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.isBeforeFirst();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean isFirst() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.isFirst();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean isLast() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.isLast();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean last() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.last();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkState();
        try {
            this.resultSet.moveToCurrentRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void moveToInsertRow() throws SQLException {
        this.checkState();
        try {
            this.resultSet.moveToInsertRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean next() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.next();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean previous() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.previous();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void refreshRow() throws SQLException {
        this.checkState();
        try {
            this.resultSet.refreshRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean relative(int rows) throws SQLException {
        this.checkState();
        try {
            return this.resultSet.relative(rows);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean rowDeleted() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.rowDeleted();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean rowInserted() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.rowInserted();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean rowUpdated() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.rowUpdated();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkState();
        try {
            this.resultSet.setFetchDirection(direction);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkState();
        try {
            this.resultSet.setFetchSize(rows);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateArray(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateArray(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateAsciiStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateAsciiStream(columnName, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateBigDecimal(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateBigDecimal(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateBinaryStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateBinaryStream(columnName, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateBlob(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateBlob(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateBoolean(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateBoolean(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateByte(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateByte(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateBytes(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateBytes(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateCharacterStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateCharacterStream(columnName, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateClob(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateClob(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateDate(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateDate(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateDouble(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateDouble(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateFloat(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateFloat(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateInt(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateInt(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateLong(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateLong(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateNull(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateNull(String columnName) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateNull(columnName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateObject(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateObject(columnIndex, x, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateObject(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateObject(columnName, x, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateRef(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateRef(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateRow() throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateShort(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateShort(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateString(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateString(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateTime(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateTime(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateTimestamp(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.checkState();
        try {
            this.resultSet.updateTimestamp(columnName, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean wasNull() throws SQLException {
        this.checkState();
        try {
            return this.resultSet.wasNull();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    SQLException checkException(Throwable t) throws SQLException {
        throw this.statement.checkException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalClose() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
        }
        this.resultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkState() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new SQLException("The result set is closed.");
            }
        }
    }
}

