/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.logging.LoggerPlugin;

public class JDK14LoggerPlugin
implements LoggerPlugin {
    private Logger log;

    public void init(String name) {
        this.log = Logger.getLogger(name);
    }

    public boolean isTraceEnabled() {
        return this.log.isLoggable(Level.FINER);
    }

    public void trace(Object message) {
        this.log.finer(message.toString());
    }

    public void trace(Object message, Throwable t) {
        this.log.log(Level.FINER, message.toString(), t);
    }

    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    public void debug(Object message) {
        this.log.fine(message.toString());
    }

    public void debug(Object message, Throwable t) {
        this.log.log(Level.FINE, message.toString(), t);
    }

    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    public void info(Object message) {
        this.log.info(message.toString());
    }

    public void info(Object message, Throwable t) {
        this.log.log(Level.INFO, message.toString(), t);
    }

    public void warn(Object message) {
        this.log.warning(message.toString());
    }

    public void warn(Object message, Throwable t) {
        this.log.log(Level.WARNING, message.toString(), t);
    }

    public void error(Object message) {
        this.log.severe(message.toString());
    }

    public void error(Object message, Throwable t) {
        this.log.log(Level.SEVERE, message.toString(), t);
    }

    public void fatal(Object message) {
        this.log.severe(message.toString());
    }

    public void fatal(Object message, Throwable t) {
        this.log.log(Level.SEVERE, message.toString(), t);
    }
}

