/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.plugins.spi.action.ControllerContextAction;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.plugins.dependency.DispatchJoinPoint;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;

public class KernelControllerContextAction
implements ControllerContextAction {
    protected Logger log = Logger.getLogger(this.getClass());

    protected static Object dispatchJoinPoint(KernelControllerContext context, Joinpoint joinpoint) throws Throwable {
        BeanMetaData metaData = context.getBeanMetaData();
        ClassLoader cl = Configurator.getClassLoader(metaData);
        AccessControlContext access = null;
        if (context instanceof AbstractKernelControllerContext) {
            AbstractKernelControllerContext theContext = (AbstractKernelControllerContext)context;
            access = theContext.getAccessControlContext();
        }
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        try {
            if (cl != null && access == null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            if (access == null) {
                Object object = joinpoint.dispatch();
                return object;
            }
            DispatchJoinPoint action = new DispatchJoinPoint(joinpoint);
            try {
                Object object = AccessController.doPrivileged(action, access);
                return object;
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
        finally {
            if (cl != null && access == null) {
                Thread.currentThread().setContextClassLoader(tcl);
            }
        }
    }

    public void install(final ControllerContext context) throws Throwable {
        if (System.getSecurityManager() == null || !(context instanceof AbstractKernelControllerContext)) {
            this.installAction((KernelControllerContext)context);
        } else {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        KernelControllerContextAction.this.installAction((KernelControllerContext)context);
                        return null;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
    }

    public void uninstall(final ControllerContext context) {
        if (System.getSecurityManager() == null || !(context instanceof AbstractKernelControllerContext)) {
            this.uninstallAction((KernelControllerContext)context);
        } else {
            PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    KernelControllerContextAction.this.uninstallAction((KernelControllerContext)context);
                    return null;
                }
            };
            AccessController.doPrivileged(action);
        }
    }

    public void installAction(KernelControllerContext context) throws Throwable {
    }

    public void uninstallAction(KernelControllerContext context) {
    }
}

