/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.repository.spi.KernelRepository;
import org.jboss.repository.spi.MetaDataContext;
import org.jboss.repository.spi.MetaDataContextFactory;

public class DescribeAction
extends KernelControllerContextAction {
    public void installAction(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        if (metaData.getBean() != null) {
            BeanInfo info = configurator.getBeanInfo(metaData);
            context.setBeanInfo(info);
            info = this.addAnnotations(context, metaData, info);
            DependencyInfo depends = context.getDependencyInfo();
            List dependencies = info.getDependencies();
            if (dependencies != null) {
                Iterator it = dependencies.iterator();
                while (it.hasNext()) {
                    AbstractDependencyItem dependency = new AbstractDependencyItem(metaData.getName(), it.next(), ControllerState.INSTANTIATED, ControllerState.INSTALLED);
                    depends.addIDependOn(dependency);
                }
            }
        }
    }

    public void uninstallAction(KernelControllerContext context) {
        context.setMetaDataContext(null);
        context.setBeanInfo(null);
    }

    private BeanInfo addAnnotations(KernelControllerContext context, BeanMetaData beanMetaData, BeanInfo beanInfo) {
        MetaDataContext metaCtx = this.addClassAnnotations(context, beanMetaData, beanInfo);
        metaCtx = this.addPropertyAnnotations(metaCtx, context, beanMetaData, beanInfo);
        return context.getBeanInfo();
    }

    private MetaDataContext addClassAnnotations(KernelControllerContext context, BeanMetaData beanMetaData, BeanInfo beanInfo) {
        Set<AnnotationMetaData> annotations = beanMetaData.getAnnotations();
        MetaDataContext metaCtx = null;
        if (annotations != null && annotations.size() > 0) {
            if (metaCtx == null) {
                metaCtx = this.getMetaDataContext(context);
            }
            if (metaCtx != null) {
                metaCtx.addAnnotations(annotations);
            }
        }
        return metaCtx;
    }

    private MetaDataContext addPropertyAnnotations(MetaDataContext metaCtx, KernelControllerContext context, BeanMetaData beanMetaData, BeanInfo beanInfo) {
        Set<PropertyMetaData> properties = beanMetaData.getProperties();
        if (properties != null && properties.size() > 0) {
            for (PropertyMetaData property : properties) {
                Set<PropertyInfo> propertyInfos;
                Set<AnnotationMetaData> propertyAnnotations = property.getAnnotations();
                if (propertyAnnotations == null || propertyAnnotations.size() <= 0) continue;
                if (metaCtx == null) {
                    metaCtx = this.getMetaDataContext(context);
                }
                if (metaCtx == null || (propertyInfos = beanInfo.getProperties()) == null || propertyInfos.size() <= 0) continue;
                metaCtx.addPropertyAnnotations(property.getName(), beanInfo.getProperties(), propertyAnnotations);
            }
        }
        return metaCtx;
    }

    private MetaDataContext getMetaDataContext(KernelControllerContext context) {
        ControllerContext repCtx = context.getController().getContext("Repository", ControllerState.INSTALLED);
        if (repCtx == null) {
            this.log.warn("You have defined annotations for bean '" + context.getName() + "', but no KernelRepository has been installed under the name 'Repository'");
            return null;
        }
        KernelRepository repository = (KernelRepository)repCtx.getTarget();
        MetaDataContextFactory metaFactory = context.getBeanInfo().getMetaDataContextFactory();
        MetaDataContext metaCtx = metaFactory.getMetaDataContext(repository, context.getName());
        context.setMetaDataContext(metaCtx);
        return metaCtx;
    }
}

