/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.plugins.event.AbstractEventEmitter;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventFilter;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.util.collection.CollectionsFactory;

public class AbstractKernelController
extends AbstractController
implements KernelController,
KernelRegistryPlugin {
    protected Kernel kernel;
    protected AbstractEventEmitter emitterDelegate = new AbstractEventEmitter();
    protected Map<Object, List<KernelControllerContext>> suppliers = CollectionsFactory.createConcurrentReaderMap();

    public KernelControllerContext install(BeanMetaData metaData) throws Throwable {
        return this.install(metaData, null);
    }

    public KernelControllerContext install(BeanMetaData metaData, Object target) throws Throwable {
        AbstractKernelControllerContext context = new AbstractKernelControllerContext(null, metaData, target);
        this.install(context);
        return context;
    }

    public KernelRegistryEntry getEntry(Object name) {
        List<KernelControllerContext> list = this.suppliers.get(name);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public synchronized ControllerContext getContext(Object name, ControllerState state) {
        ControllerContext context = super.getContext(name, state);
        if (context != null) {
            return context;
        }
        if (state == null || state == ControllerState.INSTALLED) {
            KernelRegistry registry = this.kernel.getRegistry();
            try {
                return registry.getEntry(name);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized void addSupplies(KernelControllerContext context) {
        BeanMetaData metaData = context.getBeanMetaData();
        Set<SupplyMetaData> supplies = metaData.getSupplies();
        if (supplies != null) {
            boolean trace = this.log.isTraceEnabled();
            if (!supplies.isEmpty()) {
                for (SupplyMetaData supplied : supplies) {
                    Object supply = supplied.getSupply();
                    List list = this.suppliers.get(supply);
                    if (list == null) {
                        list = CollectionsFactory.createCopyOnWriteList();
                        this.suppliers.put(supply, list);
                    }
                    list.add(context);
                    if (!trace) continue;
                    this.log.trace("Suppliers of " + supply + ": " + list);
                }
            }
        }
    }

    public synchronized void removeSupplies(KernelControllerContext context) {
        BeanMetaData metaData = context.getBeanMetaData();
        Set<SupplyMetaData> supplies = metaData.getSupplies();
        if (supplies != null) {
            boolean trace = this.log.isTraceEnabled();
            if (!supplies.isEmpty()) {
                for (SupplyMetaData supplied : supplies) {
                    Object supply = supplied.getSupply();
                    List<KernelControllerContext> list = this.suppliers.get(supply);
                    if (list == null) continue;
                    list.remove(context);
                    if (list.isEmpty()) {
                        this.suppliers.remove(supply);
                    }
                    if (!trace) continue;
                    this.log.trace("Suppliers of " + supply + ": " + list);
                }
            }
        }
    }

    public Kernel getKernel() {
        Kernel.checkAccess();
        return this.kernel;
    }

    public void setKernel(Kernel kernel) throws Throwable {
        Kernel.checkConfigure();
        this.kernel = kernel;
    }

    public void fireKernelEvent(KernelEvent event) {
        this.emitterDelegate.fireKernelEvent(event);
    }

    public void registerListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        this.emitterDelegate.registerListener(listener, filter, handback);
    }

    public void unregisterListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        this.emitterDelegate.unregisterListener(listener, filter, handback);
    }
}

