/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.ejb3.BaseContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.ThreadLocalStack;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.stateful.NestedStatefulBeanContext;
import org.jboss.ejb3.stateful.ProxiedStatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.serial.io.MarshalledObject;
import org.jboss.tm.TxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulBeanContext
extends BaseContext
implements Externalizable {
    protected Object id;
    protected boolean txSynchronized = false;
    protected boolean inInvocation = false;
    protected MarshalledObject beanMO;
    protected ReentrantLock lock = new ReentrantLock();
    protected boolean discarded;
    public static ThreadLocalStack<StatefulBeanContext> propagatedContainedIn = new ThreadLocalStack();
    public static ThreadLocalStack<StatefulBeanContext> currentBean = new ThreadLocalStack();
    protected StatefulBeanContext containedIn;
    protected List<StatefulBeanContext> contains;
    protected HashMap<String, EntityManager> persistenceContexts;
    protected boolean removed;
    protected String containerName;
    public volatile boolean markedForPassivation = false;
    public volatile boolean inUse = false;
    public volatile long lastUsed = System.currentTimeMillis();

    public List<StatefulBeanContext> getContains() {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        return this.contains;
    }

    public EntityManager getExtendedPersistenceContext(String id) {
        EntityManager found = null;
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS != null) {
            found = extendedPCS.get(id);
        }
        if (found != null) {
            return found;
        }
        if (this.containedIn != null) {
            found = this.containedIn.getExtendedPersistenceContext(id);
        }
        return found;
    }

    public void addExtendedPersistenceContext(String id, EntityManager pc) {
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS == null) {
            this.persistenceContexts = new HashMap<String, EntityManager>();
            extendedPCS = this.persistenceContexts;
        }
        extendedPCS.put(id, pc);
    }

    public Map<String, EntityManager> getExtendedPersistenceContexts() {
        if (this.persistenceContexts == null && this.bean == null) {
            this.getInstance();
        }
        return this.persistenceContexts;
    }

    public StatefulBeanContext getContainedIn() {
        return this.containedIn;
    }

    public void addContains(StatefulBeanContext ctx) {
        if (this.contains == null) {
            this.contains = new ArrayList<StatefulBeanContext>();
        }
        this.contains.add(ctx);
        ctx.containedIn = this;
    }

    public StatefulBeanContext pushContainedIn() {
        StatefulBeanContext thisPtr = this;
        if (propagatedContainedIn.getList() != null) {
            this.containedIn = propagatedContainedIn.get();
            NestedStatefulBeanContext nested = new NestedStatefulBeanContext();
            nested.id = this.id;
            nested.container = this.getContainer();
            nested.containerName = this.containerName;
            nested.bean = this.bean;
            this.containedIn.addContains(nested);
            thisPtr = new ProxiedStatefulBeanContext(nested);
        }
        propagatedContainedIn.push(thisPtr);
        return thisPtr;
    }

    public void prePassivate() {
        this.getContainer().invokePrePassivate(this);
    }

    public void postActivate() {
        this.getContainer().invokePostActivate(this);
    }

    public void popContainedIn() {
        propagatedContainedIn.pop();
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public void setDiscarded(boolean discarded) {
        this.discarded = discarded;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public boolean isInInvocation() {
        return this.inInvocation;
    }

    public void setInInvocation(boolean inInvocation) {
        this.inInvocation = inInvocation;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public boolean isTxSynchronized() {
        return this.txSynchronized;
    }

    public void setTxSynchronized(boolean txSynchronized) {
        this.txSynchronized = txSynchronized;
    }

    @Override
    public void remove() {
        if (this.removed) {
            return;
        }
        this.removed = true;
        if (this.contains != null) {
            for (StatefulBeanContext contained : this.contains) {
                ((StatefulContainer)contained.getContainer()).getCache().remove(contained.getId());
            }
        }
        try {
            Transaction tx = TxUtil.getTransactionManager().getTransaction();
            if (tx != null && TxUtils.isActive(tx)) {
                tx.registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        StatefulBeanContext.this.closeExtendedPCs();
                    }
                });
            } else {
                this.closeExtendedPCs();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void closeExtendedPCs() {
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS != null) {
            for (EntityManager pc : extendedPCS.values()) {
                pc.close();
            }
        }
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.containerName = container.getObjectName().getCanonicalName();
    }

    @Override
    public Container getContainer() {
        if (this.container == null) {
            this.container = Ejb3Registry.getContainer(this.containerName);
        }
        return this.container;
    }

    @Override
    public Object getInstance() {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        return this.bean;
    }

    @Override
    public SimpleMetaData getMetaData() {
        return super.getMetaData();
    }

    @Override
    public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos) {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        return super.getInterceptorInstances(interceptorInfos);
    }

    protected void extractBeanAndInterceptors() {
        try {
            Object[] beanAndInterceptors = (Object[])this.beanMO.get();
            this.bean = beanAndInterceptors[0];
            this.persistenceContexts = (HashMap)beanAndInterceptors[1];
            ArrayList list = (ArrayList)beanAndInterceptors[2];
            this.interceptorInstances = new HashMap();
            if (list != null) {
                for (Object o : list) {
                    this.interceptorInstances.put(o.getClass(), o);
                }
            }
            this.contains = (List)beanAndInterceptors[3];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.containerName);
        out.writeObject(this.id);
        out.writeObject(this.metadata);
        if (this.bean == null) {
            out.writeObject(this.beanMO);
        } else {
            Object[] beanAndInterceptors = new Object[4];
            beanAndInterceptors[0] = this.bean;
            beanAndInterceptors[1] = this.persistenceContexts;
            if (this.interceptorInstances != null && this.interceptorInstances.size() > 0) {
                ArrayList list = new ArrayList();
                list.addAll(this.interceptorInstances.values());
                beanAndInterceptors[2] = list;
            }
            beanAndInterceptors[3] = this.contains;
            this.beanMO = new MarshalledObject(beanAndInterceptors);
            out.writeObject(this.beanMO);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerName = in.readUTF();
        this.id = in.readObject();
        this.metadata = (SimpleMetaData)in.readObject();
        this.beanMO = (MarshalledObject)in.readObject();
    }

    @Override
    public Object getInvokedMethodKey() {
        return this.getId();
    }
}

