/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;

public class KernelErrors {
    private static final Logger log = Logger.getLogger(KernelErrors.class);

    public static boolean validate(Kernel kernel) {
        KernelController controller = kernel.getController();
        HashSet<ControllerContext> notInstalled = new HashSet<ControllerContext>(controller.getNotInstalled());
        if (notInstalled.isEmpty()) {
            return true;
        }
        Iterator i = notInstalled.iterator();
        while (i.hasNext()) {
            KernelControllerContext context = (KernelControllerContext)i.next();
            if (!context.getState().equals(context.getRequiredState())) continue;
            i.remove();
        }
        if (notInstalled.isEmpty()) {
            return true;
        }
        HashSet<KernelControllerContext> errors = new HashSet<KernelControllerContext>();
        HashSet<KernelControllerContext> incomplete = new HashSet<KernelControllerContext>();
        for (KernelControllerContext kernelControllerContext : notInstalled) {
            if (kernelControllerContext.getState().equals(ControllerState.ERROR)) {
                errors.add(kernelControllerContext);
                continue;
            }
            incomplete.add(kernelControllerContext);
        }
        if (errors.size() != 0) {
            log.error("*** DEPLOYMENTS IN ERROR:\n");
            for (KernelControllerContext kernelControllerContext : errors) {
                log.error("Failed deployment: " + kernelControllerContext.getName(), kernelControllerContext.getError());
            }
        }
        if (incomplete.size() != 0) {
            JBossStringBuilder buffer = new JBossStringBuilder();
            buffer.append("\n*** DEPLOYMENTS MISSING DEPENDENCIES:\n");
            for (KernelControllerContext ctx : incomplete) {
                buffer.append(ctx.getName()).append(" depends on: \n");
                DependencyInfo dependsInfo = ctx.getDependencyInfo();
                Set<DependencyItem> depends = dependsInfo.getIDependOn(null);
                Iterator<DependencyItem> j = depends.iterator();
                while (j.hasNext()) {
                    DependencyItem item = j.next();
                    buffer.append("                     ").append(item.getIDependOn()).append("'{").append(item.getWhenRequired().getStateString());
                    buffer.append(':');
                    ControllerContext other = controller.getContext(item.getIDependOn(), null);
                    if (other == null) {
                        buffer.append("NOT FOUND");
                    } else {
                        buffer.append(other.getState().getStateString());
                    }
                    buffer.append('}');
                    if (!j.hasNext()) continue;
                    buffer.append("\n");
                }
                buffer.append('\n');
            }
            log.error(buffer.toString());
        }
        return errors.size() <= 0 && incomplete.size() <= 0;
    }
}

