/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.util.List;
import java.util.Set;
import org.jboss.beans.info.plugins.AbstractInstanceBeanInfo;
import org.jboss.beans.info.plugins.AbstractPropertyInfo;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.beans.info.spi.EventInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.repository.spi.MetaDataContext;
import org.jboss.repository.spi.MetaDataContextFactory;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanInfo
extends JBossObject
implements BeanInfo {
    protected String name;
    protected ClassAdapter classAdapter;
    protected Set<PropertyInfo> properties;
    protected Set<ConstructorInfo> constructors;
    protected Set<MethodInfo> methods;
    protected Set<EventInfo> events;
    protected BeanInfoFactory beanInfoFactory;

    public AbstractBeanInfo(BeanInfoFactory beanInfoFactory, ClassAdapter classAdapter, Set<PropertyInfo> properties, Set<ConstructorInfo> constructors, Set<MethodInfo> methods, Set<EventInfo> events) {
        this.beanInfoFactory = beanInfoFactory;
        this.name = classAdapter.getClassInfo().getName();
        this.classAdapter = classAdapter;
        this.properties = properties;
        if (properties != null && !properties.isEmpty()) {
            for (AbstractPropertyInfo abstractPropertyInfo : properties) {
                abstractPropertyInfo.beanInfo = this;
            }
        }
        this.constructors = constructors;
        this.methods = methods;
        this.events = events;
    }

    protected AbstractBeanInfo(AbstractBeanInfo template) {
        this.name = template.name;
        this.classAdapter = template.classAdapter.getInstanceAdapter(template.classAdapter.getClassInfo());
        this.properties = template.properties;
        this.constructors = template.constructors;
        this.methods = template.methods;
        this.events = template.events;
        this.beanInfoFactory = template.beanInfoFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<PropertyInfo> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Set<PropertyInfo> properties) {
        this.properties = properties;
    }

    @Override
    public ClassInfo getClassInfo() {
        return this.classAdapter.getClassInfo();
    }

    @Override
    public List getDependencies() {
        return this.classAdapter.getDependencies();
    }

    @Override
    public JoinpointFactory getJoinpointFactory() {
        return this.classAdapter.getJoinpointFactory();
    }

    @Override
    public MetaDataContextFactory getMetaDataContextFactory() {
        return this.classAdapter.getMetaDataContextFactory();
    }

    @Override
    public Set<ConstructorInfo> getConstructors() {
        return this.constructors;
    }

    @Override
    public void setConstructors(Set<ConstructorInfo> constructors) {
        this.constructors = constructors;
    }

    @Override
    public Set<EventInfo> getEvents() {
        return this.events;
    }

    @Override
    public void setEvents(Set<EventInfo> events) {
        this.events = events;
    }

    @Override
    public Set<MethodInfo> getMethods() {
        return this.methods;
    }

    @Override
    public void setMethods(Set<MethodInfo> methods) {
        this.methods = methods;
    }

    @Override
    public BeanInfoFactory getBeanInfoFactory() {
        return this.beanInfoFactory;
    }

    @Override
    public MetaDataContext getMetaDataContext() {
        return this.classAdapter.getMetaDataContext();
    }

    @Override
    public void setMetaDataContext(MetaDataContext metaCtx) {
        this.classAdapter.setMetaDataContext(metaCtx);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractBeanInfo)) {
            return false;
        }
        AbstractBeanInfo other = (AbstractBeanInfo)object;
        if (AbstractBeanInfo.notEqual(this.name, other.name)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.classAdapter, other.classAdapter)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.properties, other.properties)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.methods, other.methods)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual(this.constructors, other.constructors)) {
            return false;
        }
        return !AbstractBeanInfo.notEqual(this.events, other.events);
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" classInfo=");
        this.classAdapter.toShortString(buffer);
        buffer.append(" properties=");
        JBossObject.list(buffer, this.properties);
        buffer.append(" methods=");
        JBossObject.list(buffer, this.methods);
        buffer.append(" constructors=");
        JBossObject.list(buffer, this.constructors);
        buffer.append(" events=");
        JBossObject.list(buffer, this.events);
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    @Override
    public int getHashCode() {
        return this.name.hashCode();
    }

    @Override
    public BeanInfo getInstanceInfo() {
        return new AbstractInstanceBeanInfo(this);
    }
}

