/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.Principal;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.security.SecurityActions;

public final class SecurityClientInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = -6366165968174741107L;
    public static final SecurityClientInterceptor singleton = new SecurityClientInterceptor();

    public String getName() {
        return "SecurityClientInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object credential;
        Principal principal = SecurityActions.getPrincipal();
        if (principal != null) {
            invocation.getMetaData().addMetaData("security", "principal", principal);
        }
        if ((credential = SecurityActions.getCredential()) != null) {
            invocation.getMetaData().addMetaData("security", "credential", credential);
        }
        return invocation.invokeNext();
    }

    Object readResolve() throws ObjectStreamException {
        return singleton;
    }
}

