/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;

public abstract class AbstractDataType
extends DataType {
    private final String _name;
    private final int _sqlType;
    private final Class _classType;
    private final boolean _isNumber;

    public AbstractDataType(String name, int sqlType, Class classType, boolean isNumber) {
        this._sqlType = sqlType;
        this._name = name;
        this._classType = classType;
        this._isNumber = isNumber;
    }

    public int compare(Object o1, Object o2) throws TypeCastException {
        try {
            Comparable value1 = (Comparable)this.typeCast(o1);
            Comparable value2 = (Comparable)this.typeCast(o2);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            return value1.compareTo(value2);
        }
        catch (ClassCastException e) {
            throw new TypeCastException(e);
        }
    }

    public int getSqlType() {
        return this._sqlType;
    }

    public Class getTypeClass() {
        return this._classType;
    }

    public boolean isNumber() {
        return this._isNumber;
    }

    public boolean isDateTime() {
        return false;
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        Object value = resultSet.getObject(column);
        if (value == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        statement.setObject(column, this.typeCast(value), this.getSqlType());
    }

    public String toString() {
        return this._name;
    }
}

