/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.AbstractTableMetaData;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoColumnsFoundException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.filter.IColumnFilter;

public class DatabaseTableMetaData
extends AbstractTableMetaData {
    private final String _tableName;
    private final IDatabaseConnection _connection;
    private Column[] _columns;
    private Column[] _primaryKeys;

    DatabaseTableMetaData(String tableName, IDatabaseConnection connection) {
        this._tableName = tableName;
        this._connection = connection;
    }

    public static ITableMetaData createMetaData(String tableName, ResultSet resultSet, IDataTypeFactory dataTypeFactory) throws DataSetException, SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        Column[] columns = new Column[metaData.getColumnCount()];
        for (int i = 0; i < columns.length; ++i) {
            int columnType = metaData.getColumnType(i + 1);
            String columnTypeName = metaData.getColumnTypeName(i + 1);
            DataType dataType = dataTypeFactory.createDataType(columnType, columnTypeName);
            columns[i] = new Column(metaData.getColumnName(i + 1), dataType, columnTypeName, Column.nullableValue(metaData.isNullable(i + 1)));
        }
        return new DefaultTableMetaData(tableName, columns);
    }

    public static ITableMetaData createMetaData(String tableName, ResultSet resultSet, IDatabaseConnection connection) throws SQLException, DataSetException {
        DatabaseConfig config = connection.getConfig();
        IDataTypeFactory typeFactory = (IDataTypeFactory)config.getProperty("http://www.dbunit.org/properties/datatypeFactory");
        return DatabaseTableMetaData.createMetaData(tableName, resultSet, typeFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getPrimaryKeyNames() throws SQLException {
        String schemaName = this._connection.getSchema();
        String tableName = this._tableName;
        int index = tableName.indexOf(".");
        if (index >= 0) {
            schemaName = tableName.substring(0, index);
            tableName = tableName.substring(index + 1);
        }
        Connection connection = this._connection.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, schemaName, tableName);
        ArrayList<PrimaryKeyData> list = new ArrayList<PrimaryKeyData>();
        try {
            while (resultSet.next()) {
                String name = resultSet.getString(4);
                int sequence = resultSet.getInt(5);
                list.add(new PrimaryKeyData(name, sequence));
            }
        }
        finally {
            resultSet.close();
        }
        Collections.sort(list);
        String[] keys = new String[list.size()];
        for (int i = 0; i < keys.length; ++i) {
            PrimaryKeyData data = (PrimaryKeyData)list.get(i);
            keys[i] = data.getName();
        }
        return keys;
    }

    public String getTableName() {
        return this._tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column[] getColumns() throws DataSetException {
        if (this._columns == null) {
            try {
                String schemaName = this._connection.getSchema();
                String tableName = this._tableName;
                int index = tableName.indexOf(".");
                if (index >= 0) {
                    schemaName = tableName.substring(0, index);
                    tableName = tableName.substring(index + 1);
                }
                Connection jdbcConnection = this._connection.getConnection();
                DatabaseMetaData databaseMetaData = jdbcConnection.getMetaData();
                ResultSet resultSet = databaseMetaData.getColumns(null, schemaName, tableName, "%");
                try {
                    DatabaseConfig config = this._connection.getConfig();
                    IDataTypeFactory dataTypeFactory = (IDataTypeFactory)config.getProperty("http://www.dbunit.org/properties/datatypeFactory");
                    boolean datatypeWarning = config.getFeature("http://www.dbunit.org/features/datatypeWarning");
                    ArrayList<Column> columnList = new ArrayList<Column>();
                    while (resultSet.next()) {
                        String columnName = resultSet.getString(4);
                        int sqlType = resultSet.getInt(5);
                        String sqlTypeName = resultSet.getString(6);
                        int nullable = resultSet.getInt(11);
                        DataType dataType = dataTypeFactory.createDataType(sqlType, sqlTypeName);
                        if (dataType != DataType.UNKNOWN) {
                            Column column = new Column(columnName, dataType, sqlTypeName, Column.nullableValue(nullable));
                            columnList.add(column);
                            continue;
                        }
                        if (!datatypeWarning) continue;
                        System.out.println("WARNING - " + tableName + "." + columnName + " data type (" + sqlType + ", \u0091" + sqlTypeName + "\u0092) not recognized and will be ignored. See FAQ for more information.");
                    }
                    if (columnList.size() == 0) {
                        throw new NoColumnsFoundException(tableName);
                    }
                    this._columns = columnList.toArray(new Column[0]);
                }
                finally {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                throw new DataSetException(e);
            }
        }
        return this._columns;
    }

    public Column[] getPrimaryKeys() throws DataSetException {
        if (this._primaryKeys == null) {
            try {
                DatabaseConfig config = this._connection.getConfig();
                IColumnFilter primaryKeysFilter = (IColumnFilter)config.getProperty("http://www.dbunit.org/properties/primaryKeyFilter");
                this._primaryKeys = primaryKeysFilter != null ? DatabaseTableMetaData.getPrimaryKeys(this.getTableName(), this.getColumns(), primaryKeysFilter) : DatabaseTableMetaData.getPrimaryKeys(this.getColumns(), this.getPrimaryKeyNames());
            }
            catch (SQLException e) {
                throw new DataSetException(e);
            }
        }
        return this._primaryKeys;
    }

    public String toString() {
        try {
            String tableName = this.getTableName();
            String columns = Arrays.asList(this.getColumns()).toString();
            String primaryKeys = Arrays.asList(this.getPrimaryKeys()).toString();
            return "table=" + tableName + ", cols=" + columns + ", pk=" + primaryKeys + "";
        }
        catch (DataSetException e) {
            return super.toString();
        }
    }

    private class PrimaryKeyData
    implements Comparable {
        private final String _name;
        private final int _index;

        public PrimaryKeyData(String name, int index) {
            this._name = name;
            this._index = index;
        }

        public String getName() {
            return this._name;
        }

        public int getIndex() {
            return this._index;
        }

        public int compareTo(Object o) {
            PrimaryKeyData data = (PrimaryKeyData)o;
            return this.getIndex() - data.getIndex();
        }
    }
}

