/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.internal.Utils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JUnitXMLReporter
implements ITestListener {
    private String m_outputFileName = null;
    private File m_outputFile = null;
    private ITestContext m_testContext = null;
    private int m_numPassed = 0;
    private int m_numFailed = 0;
    private int m_numSkipped = 0;
    private int m_numFailedButIgnored = 0;
    private List<ITestResult> m_allTests = Collections.synchronizedList(new ArrayList());

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult tr) {
        this.m_allTests.add(tr);
        ++this.m_numPassed;
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.m_allTests.add(tr);
        ++this.m_numFailedButIgnored;
    }

    public void onTestFailure(ITestResult tr) {
        this.m_allTests.add(tr);
        ++this.m_numFailed;
    }

    public void onTestSkipped(ITestResult tr) {
        this.m_allTests.add(tr);
        ++this.m_numSkipped;
    }

    public void onStart(ITestContext context) {
        this.m_outputFileName = context.getOutputDirectory() + File.separator + context.getName() + ".xml";
        this.m_outputFile = new File(this.m_outputFileName);
        this.m_testContext = context;
    }

    public void onFinish(ITestContext context) {
        this.generateReport();
    }

    protected void generateReport() {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document d = docBuilder.newDocument();
            Element rootElement = d.createElement("testsuite");
            rootElement.setAttribute("name", this.m_testContext.getName());
            Element propsElement = d.createElement("properties");
            rootElement.appendChild(propsElement);
            ISuite suite = this.m_testContext.getSuite();
            rootElement.setAttribute("tests", "" + this.m_allTests.size());
            rootElement.setAttribute("failures", "" + this.m_numFailed);
            rootElement.setAttribute("errors", "0");
            long elapsedTimeMillis = this.m_testContext.getEndDate().getTime() - this.m_testContext.getStartDate().getTime();
            rootElement.setAttribute("time", "" + (double)elapsedTimeMillis / 1000.0);
            for (ITestResult tr : this.m_allTests) {
                Element nested;
                Element testCaseElement = d.createElement("testcase");
                elapsedTimeMillis = tr.getEndMillis() - tr.getStartMillis();
                testCaseElement.setAttribute("name", tr.getName());
                testCaseElement.setAttribute("classname", tr.getTestClass().getRealClass().getName());
                testCaseElement.setAttribute("time", "" + (double)elapsedTimeMillis / 1000.0);
                if (2 == tr.getStatus()) {
                    nested = d.createElement("failure");
                    testCaseElement.appendChild(nested);
                    Throwable t = tr.getThrowable();
                    if (t != null) {
                        nested.setAttribute("type", t.getClass().getName());
                        String message = t.getMessage();
                        if (message != null && message.length() > 0) {
                            nested.setAttribute("message", message);
                        }
                        CDATASection trace = d.createCDATASection(Utils.stackTrace(t, false)[0]);
                        nested.appendChild(trace);
                    }
                } else if (3 == tr.getStatus()) {
                    nested = d.createElement("skipped");
                    testCaseElement.appendChild(nested);
                }
                rootElement.appendChild(testCaseElement);
            }
            BufferedWriter fw = new BufferedWriter(new FileWriter(this.m_outputFile));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(rootElement), new StreamResult(fw));
            fw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("failed to create JUnitXML because of " + ioe);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            System.err.println("failed to create JUnitXML because of " + pce);
        }
        catch (TransformerException te) {
            te.printStackTrace();
            System.err.println("Error while writing out JUnitXML because of " + te);
        }
    }
}

