/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.graph;

import java.util.ArrayList;
import java.util.LinkedList;
import org.jboss.util.graph.DFSVisitor;
import org.jboss.util.graph.Edge;
import org.jboss.util.graph.Vertex;
import org.jboss.util.graph.Visitor;
import org.jboss.util.graph.VisitorEX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T> {
    public static final int VISIT_COLOR_WHITE = 1;
    public static final int VISIT_COLOR_GREY = 2;
    public static final int VISIT_COLOR_BLACK = 3;
    private ArrayList<Vertex<T>> verticies = new ArrayList();
    private ArrayList<Edge<T>> edges = new ArrayList();

    public boolean isEmpty() {
        return this.verticies.size() == 0;
    }

    public boolean addVertex(Vertex<T> v) {
        return this.verticies.add(v);
    }

    public int size() {
        return this.verticies.size();
    }

    public Vertex<T> getVertex(int n) {
        Vertex<T> v = this.verticies.get(n);
        return v;
    }

    public boolean addEdge(Vertex<T> from, Vertex<T> to, int cost) {
        Edge<T> e = new Edge<T>(from, to, cost);
        if (from.findEdge(to) != null) {
            return false;
        }
        from.addEdge(e);
        to.addEdge(e);
        this.edges.add(e);
        return true;
    }

    public boolean insertBiEdge(Vertex<T> from, Vertex<T> to, int cost) {
        return this.addEdge(from, to, cost) && this.addEdge(to, from, cost);
    }

    public boolean removeVertex(Vertex<T> from) {
        Edge<T> e;
        int n;
        if (!this.verticies.contains(from)) {
            return false;
        }
        this.verticies.remove(from);
        for (n = 0; n < from.getOutgoingEdgeCount(); ++n) {
            e = from.getOutgoingEdge(n);
            from.remove(e);
            Vertex<T> to = e.getTo();
            to.remove(e);
            this.edges.remove(e);
        }
        for (n = 0; n < from.getIncomingEdgeCount(); ++n) {
            e = from.getIncomingEdge(n);
            from.remove(e);
            Vertex<T> predecessor = e.getFrom();
            predecessor.remove(e);
        }
        return true;
    }

    public boolean removeEdge(Vertex<T> from, Vertex<T> to) {
        Edge<T> e = from.findEdge(to);
        if (e == null) {
            return false;
        }
        from.remove(e);
        to.remove(e);
        this.edges.remove(e);
        return true;
    }

    public void clearMark() {
        for (int i = 0; i < this.verticies.size(); ++i) {
            Vertex<T> w = this.verticies.get(i);
            w.clearMark();
        }
    }

    public void clearEdges() {
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge<T> e = this.edges.get(i);
            e.clearMark();
        }
    }

    public void depthFirstSearch(Vertex<T> v, final Visitor<T> visitor) {
        VisitorEX wrapper = new VisitorEX<T, RuntimeException>(){

            @Override
            public void visit(Graph<T> g, Vertex<T> v) throws RuntimeException {
                visitor.visit(g, v);
            }
        };
        this.depthFirstSearch(v, wrapper);
    }

    public <E extends Exception> void depthFirstSearch(Vertex<T> v, VisitorEX<T, E> visitor) throws E {
        if (visitor != null) {
            visitor.visit(this, v);
        }
        v.visit();
        for (int i = 0; i < v.getOutgoingEdgeCount(); ++i) {
            Edge<T> e = v.getOutgoingEdge(i);
            if (e.getTo().visited()) continue;
            this.depthFirstSearch(e.getTo(), visitor);
        }
    }

    public void breadthFirstSearch(Vertex<T> v, final Visitor<T> visitor) {
        VisitorEX wrapper = new VisitorEX<T, RuntimeException>(){

            @Override
            public void visit(Graph<T> g, Vertex<T> v) throws RuntimeException {
                visitor.visit(g, v);
            }
        };
        this.breadthFirstSearch(v, wrapper);
    }

    public <E extends Exception> void breadthFirstSearch(Vertex<T> v, VisitorEX<T, E> visitor) throws E {
        LinkedList q = new LinkedList();
        q.add(v);
        if (visitor != null) {
            visitor.visit(this, v);
        }
        v.visit();
        while (!q.isEmpty()) {
            v = (Vertex)q.removeFirst();
            for (int i = 0; i < v.getOutgoingEdgeCount(); ++i) {
                Edge e = v.getOutgoingEdge(i);
                if (e.getTo().visited()) continue;
                q.add(e.getTo());
                if (visitor != null) {
                    visitor.visit(this, e.getTo());
                }
                e.getTo().visit();
            }
        }
    }

    public void dfsSpanningTree(Vertex<T> v, DFSVisitor<T> visitor) {
        v.visit();
        if (visitor != null) {
            visitor.visit(this, v);
        }
        for (int i = 0; i < v.getOutgoingEdgeCount(); ++i) {
            Edge<T> e = v.getOutgoingEdge(i);
            if (e.getTo().visited()) continue;
            if (visitor != null) {
                visitor.visit(this, v, e);
            }
            e.mark();
            this.dfsSpanningTree(e.getTo(), visitor);
        }
    }

    public Edge<T>[] findCycles() {
        Vertex<T> v;
        int n;
        ArrayList<Edge<Edge>> cycleEdges = new ArrayList<Edge<Edge>>();
        for (n = 0; n < this.verticies.size(); ++n) {
            v = this.getVertex(n);
            v.setMarkState(1);
        }
        for (n = 0; n < this.verticies.size(); ++n) {
            v = this.getVertex(n);
            this.visit(v, cycleEdges);
        }
        Edge[] cycles = new Edge[cycleEdges.size()];
        cycleEdges.toArray(cycles);
        return cycles;
    }

    private void visit(Vertex<T> v, ArrayList<Edge<T>> cycleEdges) {
        v.setMarkState(2);
        int count = v.getOutgoingEdgeCount();
        for (int n = 0; n < count; ++n) {
            Edge<T> e = v.getOutgoingEdge(n);
            Vertex<T> u = e.getTo();
            if (u.getMarkState() == 2) {
                cycleEdges.add(e);
                continue;
            }
            if (u.getMarkState() != 1) continue;
            this.visit(u, cycleEdges);
        }
        v.setMarkState(3);
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("Graph[");
        for (int i = 0; i < this.verticies.size(); ++i) {
            Vertex<T> v = this.verticies.get(i);
            tmp.append(v);
        }
        tmp.append(']');
        return tmp.toString();
    }
}

