/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.Util;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.plugins.SubjectActions;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

public class JaasSecurityManager
extends ServiceMBeanSupport
implements SubjectSecurityManager,
RealmMapping {
    private String securityDomain;
    private CachePolicy domainCache;
    private CallbackHandler handler;
    private Method setSecurityInfo;
    private boolean deepCopySubjectOption = false;
    protected Logger log;
    protected boolean trace;
    static /* synthetic */ Class class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo;

    public JaasSecurityManager() {
        this("other", new SecurityAssociationHandler());
    }

    public JaasSecurityManager(String securityDomain, CallbackHandler handler) {
        this.securityDomain = securityDomain;
        this.handler = handler;
        String categoryName = this.getClass().getName() + '.' + securityDomain;
        this.log = Logger.getLogger(categoryName);
        this.trace = this.log.isTraceEnabled();
        Class[] sig = new Class[]{Principal.class, Object.class};
        try {
            this.setSecurityInfo = handler.getClass().getMethod("setSecurityInfo", sig);
        }
        catch (Exception e) {
            String msg = "Failed to find setSecurityInfo(Princpal, Object) method in handler";
            throw new UndeclaredThrowableException(e, msg);
        }
        this.log.debug("CallbackHandler: " + handler);
    }

    public void setCachePolicy(CachePolicy domainCache) {
        this.domainCache = domainCache;
        this.log.debug("CachePolicy set to: " + domainCache);
    }

    public void setDeepCopySubjectOption(Boolean flag) {
        this.log.debug("setDeepCopySubjectOption=" + flag);
        this.deepCopySubjectOption = flag == Boolean.TRUE;
    }

    public void flushCache() {
        if (this.domainCache != null) {
            this.domainCache.flush();
        }
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public Subject getActiveSubject() {
        return SecurityAssociation.getSubject();
    }

    public boolean isValid(Principal principal, Object credential) {
        return this.isValid(principal, credential, null);
    }

    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        DomainInfo cacheInfo = this.getCacheInfo(principal, true);
        if (this.trace) {
            this.log.trace("Begin isValid, principal:" + principal + ", cache info: " + cacheInfo);
        }
        boolean isValid = false;
        if (cacheInfo != null) {
            isValid = this.validateCache(cacheInfo, credential, activeSubject);
            if (cacheInfo != null) {
                cacheInfo.release();
            }
        }
        if (!isValid) {
            isValid = this.authenticate(principal, credential, activeSubject);
        }
        if (this.trace) {
            this.log.trace("End isValid, " + isValid);
        }
        return isValid;
    }

    public Principal getPrincipal(Principal principal) {
        AuthorizationManager am = Util.getAuthorizationManager(this.securityDomain);
        return am.getPrincipal(principal);
    }

    public boolean doesUserHaveRole(Principal principal, Set rolePrincipals) {
        AuthorizationManager am = Util.getAuthorizationManager(this.securityDomain);
        return am.doesUserHaveRole(principal, rolePrincipals);
    }

    public Set getUserRoles(Principal principal) {
        AuthorizationManager am = Util.getAuthorizationManager(this.securityDomain);
        return am.getUserRoles(principal);
    }

    private boolean authenticate(Principal principal, Object credential, Subject theSubject) {
        Subject subject = null;
        boolean authenticated = false;
        LoginException authException = null;
        try {
            LoginContext lc = this.defaultLogin(principal, credential);
            subject = lc.getSubject();
            if (subject != null) {
                if (theSubject != null) {
                    SubjectActions.copySubject(subject, theSubject, false, this.deepCopySubjectOption);
                } else {
                    theSubject = subject;
                }
                authenticated = true;
                this.updateCache(lc, subject, principal, credential);
            }
        }
        catch (LoginException e) {
            if (principal != null && principal.getName() != null || this.trace) {
                this.log.trace("Login failure", e);
            }
            authException = e;
        }
        SubjectActions.setContextInfo("org.jboss.security.exception", authException);
        return authenticated;
    }

    private LoginContext defaultLogin(Principal principal, Object credential) throws LoginException {
        Object[] securityInfo = new Object[]{principal, credential};
        CallbackHandler theHandler = null;
        try {
            theHandler = (CallbackHandler)this.handler.getClass().newInstance();
            this.setSecurityInfo.invoke((Object)theHandler, securityInfo);
        }
        catch (Throwable e) {
            if (this.trace) {
                this.log.trace("Failed to create/setSecurityInfo on handler", e);
            }
            LoginException le = new LoginException("Failed to setSecurityInfo on handler");
            le.initCause(e);
            throw le;
        }
        Subject subject = new Subject();
        LoginContext lc = null;
        if (this.trace) {
            this.log.trace("defaultLogin, principal=" + principal);
        }
        lc = SubjectActions.createLoginContext(this.securityDomain, subject, theHandler);
        lc.login();
        if (this.trace) {
            this.log.trace("defaultLogin, lc=" + lc + ", subject=" + SubjectActions.toString(subject));
        }
        return lc;
    }

    private boolean validateCache(DomainInfo info, Object credential, Subject theSubject) {
        if (this.trace) {
            StringBuffer tmp = new StringBuffer("Begin validateCache, info=");
            tmp.append(info.toString());
            tmp.append(";credential.class=");
            if (credential != null) {
                Class<?> c = credential.getClass();
                tmp.append(c.getName());
                tmp.append('@');
                tmp.append(System.identityHashCode(c));
            } else {
                tmp.append("null");
            }
            this.log.trace(tmp.toString());
        }
        Object subjectCredential = info.credential;
        boolean isValid = false;
        if (credential == null || subjectCredential == null) {
            isValid = credential == null && subjectCredential == null;
        } else if (subjectCredential.getClass().isAssignableFrom(credential.getClass())) {
            if (subjectCredential instanceof Comparable) {
                Comparable c = (Comparable)subjectCredential;
                isValid = c.compareTo(credential) == 0;
            } else if (subjectCredential instanceof char[]) {
                char[] a1 = (char[])subjectCredential;
                char[] a2 = (char[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential instanceof byte[]) {
                byte[] a1 = (byte[])subjectCredential;
                byte[] a2 = (byte[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential.getClass().isArray()) {
                Object[] a1 = (Object[])subjectCredential;
                Object[] a2 = (Object[])credential;
                isValid = Arrays.equals(a1, a2);
            } else {
                isValid = subjectCredential.equals(credential);
            }
        } else if (subjectCredential instanceof char[] && credential instanceof String) {
            char[] a1 = (char[])subjectCredential;
            char[] a2 = ((String)credential).toCharArray();
            isValid = Arrays.equals(a1, a2);
        } else if (subjectCredential instanceof String && credential instanceof char[]) {
            char[] a1 = ((String)subjectCredential).toCharArray();
            char[] a2 = (char[])credential;
            isValid = Arrays.equals(a1, a2);
        }
        if (isValid && theSubject != null) {
            SubjectActions.copySubject(info.subject, theSubject, false, this.deepCopySubjectOption);
        }
        if (this.trace) {
            this.log.trace("End validateCache, isValid=" + isValid);
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainInfo getCacheInfo(Principal principal, boolean allowRefresh) {
        if (this.domainCache == null) {
            return null;
        }
        DomainInfo cacheInfo = null;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            cacheInfo = allowRefresh ? (DomainInfo)this.domainCache.get(principal) : (DomainInfo)this.domainCache.peek(principal);
            if (cacheInfo != null) {
                cacheInfo.acquire();
            }
        }
        return cacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subject updateCache(LoginContext lc, Subject subject, Principal principal, Object credential) {
        if (this.domainCache == null) {
            return subject;
        }
        long lifetime = 0L;
        if (this.domainCache instanceof TimedCachePolicy) {
            TimedCachePolicy cache = (TimedCachePolicy)this.domainCache;
            lifetime = cache.getDefaultLifetime();
        }
        DomainInfo info = new DomainInfo(lifetime);
        info.loginCtx = lc;
        info.subject = new Subject();
        SubjectActions.copySubject(subject, info.subject, true, this.deepCopySubjectOption);
        info.credential = credential;
        if (this.trace) {
            this.log.trace("updateCache, inputSubject=" + SubjectActions.toString(subject) + ", cacheSubject=" + SubjectActions.toString(info.subject));
        }
        Set subjectGroups = subject.getPrincipals(Group.class);
        Iterator iter = subjectGroups.iterator();
        while (iter.hasNext()) {
            Enumeration members;
            Group grp = (Group)iter.next();
            String name = grp.getName();
            if (!name.equals("CallerPrincipal") || !(members = grp.members()).hasMoreElements()) continue;
            info.callerPrincipal = (Principal)members.nextElement();
        }
        if (principal == null && info.callerPrincipal == null) {
            Set subjectPrincipals = subject.getPrincipals(Principal.class);
            iter = subjectPrincipals.iterator();
            while (iter.hasNext()) {
                Principal p = (Principal)iter.next();
                if (p instanceof Group) continue;
                info.callerPrincipal = p;
            }
        }
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            if (this.domainCache.peek(principal) != null) {
                this.domainCache.remove(principal);
            }
            this.domainCache.insert(principal, info);
            if (this.trace) {
                this.log.trace("Inserted cache info: " + info);
            }
        }
        return info.subject;
    }

    public static class DomainInfo
    implements TimedCachePolicy.TimedEntry {
        private static Logger log = Logger.getLogger(class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo == null ? (class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo = JaasSecurityManager.class$("org.jboss.security.plugins.JaasSecurityManager$DomainInfo")) : class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo);
        private static boolean trace = log.isTraceEnabled();
        private LoginContext loginCtx;
        private Subject subject;
        private Object credential;
        private Principal callerPrincipal;
        private long expirationTime;
        private boolean needsDestroy;
        private int activeUsers;

        public DomainInfo(long lifetime) {
            this.expirationTime = lifetime;
            if (this.expirationTime != -1L) {
                this.expirationTime *= 1000L;
            }
        }

        synchronized int acquire() {
            return this.activeUsers++;
        }

        synchronized int release() {
            int users = this.activeUsers--;
            if (this.needsDestroy && users == 0) {
                if (trace) {
                    log.trace("needsDestroy is true, doing logout");
                }
                this.logout();
            }
            return users;
        }

        synchronized void logout() {
            block4: {
                if (trace) {
                    log.trace("logout, subject=" + this.subject + ", this=" + this);
                }
                try {
                    if (this.loginCtx != null) {
                        this.loginCtx.logout();
                    }
                }
                catch (Throwable e) {
                    if (!trace) break block4;
                    log.trace("Cache entry logout failed", e);
                }
            }
        }

        public void init(long now) {
            this.expirationTime += now;
        }

        public boolean isCurrent(long now) {
            boolean isCurrent;
            boolean bl = isCurrent = this.expirationTime == -1L;
            if (!isCurrent) {
                isCurrent = this.expirationTime > now;
            }
            return isCurrent;
        }

        public boolean refresh() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            if (trace) {
                log.trace("destroy, subject=" + this.subject + ", this=" + this + ", activeUsers=" + this.activeUsers);
            }
            DomainInfo domainInfo = this;
            synchronized (domainInfo) {
                if (this.activeUsers == 0) {
                    this.logout();
                } else {
                    if (trace) {
                        log.trace("destroy saw activeUsers=" + this.activeUsers);
                    }
                    this.needsDestroy = true;
                }
            }
        }

        public Object getValue() {
            return this;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append('[');
            tmp.append(SubjectActions.toString(this.subject));
            tmp.append(",credential.class=");
            if (this.credential != null) {
                Class<?> c = this.credential.getClass();
                tmp.append(c.getName());
                tmp.append('@');
                tmp.append(System.identityHashCode(c));
            } else {
                tmp.append("null");
            }
            tmp.append(",expirationTime=");
            tmp.append(this.expirationTime);
            tmp.append(']');
            return tmp.toString();
        }
    }
}

