/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
import org.jboss.remoting.transport.multiplex.MasterServerSocket;
import org.jboss.remoting.transport.multiplex.MultiplexClientInvoker;
import org.jboss.remoting.transport.multiplex.MultiplexInvokerConstants;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.AddressPair;
import org.jboss.remoting.transport.socket.SocketServerInvoker;
import org.jboss.remoting.util.socket.RemotingSSLSocketFactory;

public class MultiplexServerInvoker
extends SocketServerInvoker
implements MultiplexInvokerConstants,
Runnable,
VirtualSocket.DisconnectListener {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker = MultiplexServerInvoker.class$("org.jboss.remoting.transport.multiplex.MultiplexServerInvoker")) : class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker);
    private static Map socketGroupMap = new HashMap();
    private static Map addressPairMap = new HashMap();
    private boolean isVirtual = false;
    private Map virtualServerInvokers;
    private Socket connectPrimingSocket;
    private String socketGroupId;
    private SocketGroupInfo socketGroupInfo;
    private AddressPair addressPair;
    private String bindHost;
    private int bindPort;
    private int originalBindPort;
    private InetAddress bindAddress;
    private InetSocketAddress connectSocketAddress;
    private boolean readyToStart = true;
    private boolean needsSocketGroupConfiguration = true;
    private boolean cleanedUp;
    private SocketFactory socketFactory;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo;

    public static Map getAddressPairMap() {
        return addressPairMap;
    }

    public static Map getSocketGroupMap() {
        return socketGroupMap;
    }

    public MultiplexServerInvoker(InvokerLocator locator) {
        super(locator);
        this.virtualServerInvokers = Collections.synchronizedMap(new HashMap());
    }

    public MultiplexServerInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
        this.virtualServerInvokers = Collections.synchronizedMap(new HashMap());
    }

    protected MultiplexServerInvoker(InvokerLocator locator, Map configuration, ServerSocket serverSocket, Socket socket, Map virtualServerInvokers) {
        super(locator, configuration);
        this.serverSocket = serverSocket;
        this.connectPrimingSocket = socket;
        this.virtualServerInvokers = virtualServerInvokers;
        this.isVirtual = true;
        this.needsSocketGroupConfiguration = false;
        ((VirtualSocket)this.connectPrimingSocket).addDisconnectListener(this);
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public void start() throws IOException {
        this.socketFactory = this.createSocketFactory(this.configuration);
        this.setBindingInfo();
        if (!this.configuration.isEmpty() && this.needsSocketGroupConfiguration) {
            try {
                this.configureSocketGroupParameters(this.configuration);
            }
            catch (IOException e) {
                this.cleanup();
                throw e;
            }
        }
        if (this.readyToStart) {
            this.finishStart();
        }
    }

    public void run() {
        if (this.trace) {
            log.trace("Started execution of method run");
        }
        while (this.running) {
            try {
                if (this.trace) {
                    log.trace("Socket is going to be accepted");
                }
                Socket socket = this.serverSocket.accept();
                if (this.trace) {
                    log.trace("Accepted: " + socket);
                }
                this.processInvocation(socket);
            }
            catch (SocketTimeoutException e) {
                if (!this.running || this.connectPrimingSocket == null || !((VirtualSocket)this.connectPrimingSocket).hasReceivedDisconnectMessage()) continue;
                log.debug("Client has closed: shutting down");
                this.stop();
                return;
            }
            catch (SSLException e) {
                log.error("SSLServerSocket error", e);
                return;
            }
            catch (Throwable ex) {
                if (!this.running) continue;
                log.error("Failed to accept socket connection", ex);
            }
        }
    }

    public boolean isSafeToShutdown() {
        return this.connectPrimingSocket == null || ((VirtualSocket)this.connectPrimingSocket).hasReceivedDisconnectMessage();
    }

    public void notifyDisconnected(VirtualSocket virtualSocket) {
        if (virtualSocket != this.connectPrimingSocket) {
            log.error("notified about disconnection of unrecognized virtual socket");
            return;
        }
        log.debug("remote peer socket has closed: stopping");
        this.stop();
    }

    public void stop() {
        if (!this.running) {
            this.cleanup();
        }
        super.stop();
    }

    protected void setup() throws Exception {
        this.originalBindPort = this.getLocator().getPort();
        super.setup();
    }

    protected void finishStart() throws IOException {
        int connectPort;
        log.debug("entering finishStart()");
        if (this.isStarted()) {
            return;
        }
        if (this.socketGroupInfo != null && this.connectSocketAddress == null) {
            InetAddress connectAddress = this.socketGroupInfo.getConnectAddress();
            connectPort = this.socketGroupInfo.getConnectPort();
            this.connectSocketAddress = new InetSocketAddress(connectAddress, connectPort);
        }
        if (this.socketGroupInfo != null && this.addressPair == null) {
            String connectHost = this.socketGroupInfo.getConnectAddress().getHostName();
            connectPort = this.socketGroupInfo.getConnectPort();
            this.addressPair = new AddressPair(connectHost, connectPort, this.bindHost, this.bindPort);
        }
        try {
            super.start();
        }
        catch (IOException e) {
            log.error("Error starting MultiplexServerInvoker.", e);
            this.cleanup();
        }
        if (this.running) {
            log.debug("MultiplexServerInvoker started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureSocketGroupParameters(Map parameters) throws IOException {
        log.debug("entering configureSocketGroupParameters()");
        log.debug(this.locator);
        int connectPort = -1;
        this.socketGroupId = (String)parameters.get("serverMultiplexId");
        Class clazz = class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo = MultiplexServerInvoker.class$("org.jboss.remoting.transport.multiplex.MultiplexServerInvoker$SocketGroupInfo")) : class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo;
        synchronized (clazz) {
            if (this.socketGroupId != null && (this.socketGroupInfo = (SocketGroupInfo)MultiplexServerInvoker.getSocketGroupMap().get(this.socketGroupId)) != null) {
                log.debug("server rule 1");
                InetAddress socketGroupBindAddress = this.socketGroupInfo.getBindAddress();
                int socketGroupBindPort = this.socketGroupInfo.getBindPort();
                if (socketGroupBindAddress != null && !socketGroupBindAddress.equals(this.bindAddress)) {
                    String message = "socket group bind address (" + socketGroupBindAddress + ") does not match bind address (" + this.bindAddress + ")";
                    log.error(message);
                    this.socketGroupInfo = null;
                    throw new IOException(message);
                }
                if (socketGroupBindPort > 0 && socketGroupBindPort != this.bindPort) {
                    String message = "socket group bind port (" + socketGroupBindPort + ") does not match bind port (" + this.bindPort + ")";
                    log.error(message);
                    this.socketGroupInfo = null;
                    throw new IOException(message);
                }
                this.isVirtual = true;
                InetAddress connectAddress = this.socketGroupInfo.getConnectAddress();
                connectPort = this.socketGroupInfo.getConnectPort();
                this.connectSocketAddress = new InetSocketAddress(connectAddress, connectPort);
                this.socketGroupInfo.setBindAddress(this.bindAddress);
                this.socketGroupInfo.setBindPort(this.bindPort);
                this.socketGroupInfo.setServerInvoker(this);
                Iterator it = this.socketGroupInfo.getClientInvokers().iterator();
                while (it.hasNext()) {
                    ((MultiplexClientInvoker)it.next()).finishStart();
                }
                this.readyToStart = true;
                if (this.socketGroupInfo.getPrimingSocket() == null) {
                    MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectAddress.getHostName(), connectPort, this.bindAddress, this.bindPort, this.socketFactory, this.getTimeout());
                }
                String connectHost = connectAddress.getHostName();
                this.addressPair = new AddressPair(connectHost, connectPort, this.bindHost, this.bindPort);
                addressPairMap.put(this.addressPair, this.socketGroupInfo);
                return;
            }
            String connectHost = (String)parameters.get("multiplexConnectHost");
            String connectPortString = (String)parameters.get("multiplexConnectPort");
            if (connectHost != null && connectPortString == null) {
                throw new IOException("multiplexConnectHost != null and multiplexConnectPort == null");
            }
            if (connectHost == null && connectPortString != null) {
                throw new IOException("multiplexConnectHost == null and multiplexConnectPort != null");
            }
            if (connectHost != null) {
                log.debug("server rule 2");
                this.isVirtual = true;
                try {
                    connectPort = Integer.parseInt(connectPortString);
                }
                catch (NumberFormatException e) {
                    throw new IOException("number format error for callbackPort: " + connectPortString);
                }
                this.connectSocketAddress = new InetSocketAddress(connectHost, connectPort);
                this.addressPair = new AddressPair(connectHost, connectPort, this.bindHost, this.bindPort);
                this.socketGroupInfo = (SocketGroupInfo)addressPairMap.get(this.addressPair);
                if (this.socketGroupInfo != null) {
                    if (this.socketGroupId != null) {
                        String socketGroupSocketGroupId = this.socketGroupInfo.getSocketGroupId();
                        if (socketGroupSocketGroupId != null && socketGroupSocketGroupId != this.socketGroupId) {
                            String message = "socket group multiplexId (" + socketGroupSocketGroupId + ") does not match multiplexId (" + this.socketGroupId + ")";
                            log.error(message);
                            this.socketGroupInfo = null;
                            throw new IOException(message);
                        }
                        if (socketGroupSocketGroupId == null) {
                            this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
                            MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
                        }
                    }
                    this.socketGroupInfo.setBindAddress(this.bindAddress);
                    this.socketGroupInfo.setBindPort(this.bindPort);
                    this.socketGroupInfo.setServerInvoker(this);
                    this.readyToStart = true;
                    return;
                }
                this.socketGroupInfo = new SocketGroupInfo();
                this.socketGroupInfo.setBindAddress(this.bindAddress);
                this.socketGroupInfo.setBindPort(this.bindPort);
                this.socketGroupInfo.setServerInvoker(this);
                InetAddress connectAddress = InetAddress.getByName(connectHost);
                this.socketGroupInfo.setConnectAddress(connectAddress);
                this.socketGroupInfo.setConnectPort(connectPort);
                MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, connectPort, this.bindAddress, this.bindPort, this.socketFactory, this.getTimeout());
                addressPairMap.put(this.addressPair, this.socketGroupInfo);
                if (this.socketGroupId != null) {
                    this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
                    socketGroupMap.put(this.socketGroupId, this.socketGroupInfo);
                }
                this.readyToStart = true;
                return;
            }
            if (this.socketGroupId != null) {
                log.debug("server rule 3");
                this.socketGroupInfo = new SocketGroupInfo();
                this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
                this.socketGroupInfo.setServerInvoker(this);
                this.socketGroupInfo.setBindAddress(this.bindAddress);
                this.socketGroupInfo.setBindPort(this.bindPort);
                socketGroupMap.put(this.socketGroupId, this.socketGroupInfo);
                this.isVirtual = true;
                this.readyToStart = false;
                return;
            }
            log.debug("server rule 4");
            this.isVirtual = false;
            this.readyToStart = true;
        }
    }

    protected static void createPrimingSocket(SocketGroupInfo socketGroupInfo, String connectHost, int connectPort, SocketFactory socketFactory, int timeout) throws IOException {
        MultiplexServerInvoker.createPrimingSocket(socketGroupInfo, connectHost, connectPort, null, -1, socketFactory, timeout);
    }

    protected static void createPrimingSocket(SocketGroupInfo socketGroupInfo, String connectHost, int connectPort, InetAddress bindAddress, int bindPort, SocketFactory socketFactory, int timeout) throws IOException {
        MultiplexingManager manager;
        log.debug("entering createPrimingSocket()");
        boolean needed = true;
        InetSocketAddress csa = new InetSocketAddress(connectHost, connectPort);
        InetSocketAddress bsa = null;
        if (bindAddress != null) {
            bsa = new InetSocketAddress(bindAddress, bindPort);
            needed = !MultiplexingManager.checkForShareableManagerByAddressPair(bsa, csa);
        } else {
            boolean bl = needed = !MultiplexingManager.checkForShareableManager(csa);
        }
        if (socketGroupInfo != null) {
            socketGroupInfo.setPrimingSocketNeeded(needed);
        }
        if (!needed) {
            log.debug("priming socket is not necessary");
            return;
        }
        VirtualSocket socket = new VirtualSocket();
        socket.setSocketFactory(socketFactory);
        if (bindAddress != null) {
            socket.connect(csa, bsa, timeout);
        } else {
            socket.connect(csa, timeout);
        }
        if (socketGroupInfo != null) {
            socketGroupInfo.setPrimingSocket(socket);
        }
        if (!(manager = socket.getManager()).waitForRemoteServerSocketRegistered()) {
            throw new IOException("error waiting for remote server socket to be registered");
        }
        log.debug("created priming socket");
    }

    protected String getThreadName(int i) {
        String virtualTag = this.isVirtual ? "v" : "m";
        return "MultiplexServerInvoker#" + i + virtualTag + "-" + this.serverSocket.toString();
    }

    protected void processInvocation(Socket socket) throws Exception {
        if (this.isVirtual) {
            super.processInvocation(socket);
        } else {
            log.debug("creating VSS");
            VirtualServerSocket ss = new VirtualServerSocket((VirtualSocket)socket);
            ((ServerSocket)ss).setSoTimeout(this.getTimeout());
            MultiplexServerInvoker si = new MultiplexServerInvoker(this.locator, this.getConfiguration(), ss, socket, this.virtualServerInvokers);
            si.clientCallbackListener = this.clientCallbackListener;
            si.handlers = this.handlers;
            this.virtualServerInvokers.put(socket.getRemoteSocketAddress(), si);
            si.create();
            si.start();
            log.debug("created virtual MultiplexServerInvoker: " + si);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Iterator it;
        log.debug("entering MultiplexServerInvoker.cleanup()");
        if (this.running) {
            super.cleanup();
        }
        if (this.cleanedUp) {
            return;
        }
        this.cleanedUp = true;
        if (this.isVirtual) {
            if (this.connectPrimingSocket != null) {
                SocketAddress key = this.connectPrimingSocket.getRemoteSocketAddress();
                if (this.virtualServerInvokers.containsKey(key)) {
                    this.virtualServerInvokers.remove(key);
                }
                try {
                    log.debug("MultiplexServerInvoker: closing connect priming socket");
                    this.connectPrimingSocket.close();
                }
                catch (IOException e) {
                    log.error("Error closing connect priming socket during cleanup upon stopping", e);
                }
            } else {
                log.info("connect priming socket == null");
            }
            it = this.handlers.values().iterator();
            if (it.hasNext()) {
                ServerInvocationHandler defaultHandler = (ServerInvocationHandler)it.next();
                ServerInvocationHandler handler = null;
                ServerInvokerCallbackHandler callbackHandler = null;
                it = this.callbackHandlers.values().iterator();
                while (it.hasNext()) {
                    callbackHandler = (ServerInvokerCallbackHandler)it.next();
                    String subsystem = callbackHandler.getSubsystem();
                    handler = subsystem == null ? defaultHandler : (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
                    handler.removeListener(callbackHandler);
                }
            }
        } else {
            it = this.virtualServerInvokers.values().iterator();
            while (it.hasNext()) {
                ServerInvoker serverInvoker = (ServerInvoker)it.next();
                it.remove();
                serverInvoker.stop();
            }
        }
        if (this.socketGroupInfo != null) {
            Class clazz = class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo = MultiplexServerInvoker.class$("org.jboss.remoting.transport.multiplex.MultiplexServerInvoker$SocketGroupInfo")) : class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker$SocketGroupInfo;
            synchronized (clazz) {
                this.socketGroupInfo.removeServerInvoker(this);
                VirtualSocket ps = null;
                if (this.socketGroupInfo.getClientInvokers().isEmpty()) {
                    log.debug("invoker group shutting down: " + this.socketGroupInfo.getSocketGroupId());
                    ps = this.socketGroupInfo.getPrimingSocket();
                    if (ps != null) {
                        log.debug("MultiplexServerInvoker: closing bind priming socket");
                        try {
                            ((Socket)ps).close();
                        }
                        catch (IOException e) {
                            log.error("Error closing bind priming socket during cleanup upon stopping", e);
                        }
                    }
                    this.socketGroupId = this.socketGroupInfo.getSocketGroupId();
                    if (this.socketGroupId != null) {
                        MultiplexServerInvoker.getSocketGroupMap().remove(this.socketGroupId);
                    }
                    if (this.addressPair != null) {
                        MultiplexServerInvoker.getAddressPairMap().remove(this.addressPair);
                    }
                }
            }
        }
    }

    protected ServerSocket createServerSocket(int bindPort, int backlog, InetAddress bindAddress) throws IOException {
        if (this.serverSocket != null) {
            return this.serverSocket;
        }
        ServerSocket svrSocket = null;
        if (this.isVirtual) {
            InetSocketAddress bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
            svrSocket = new VirtualServerSocket(this.connectSocketAddress, bindSocketAddress, this.getTimeout());
            svrSocket.setSoTimeout(this.getTimeout());
            if (this.socketGroupInfo != null) {
                this.socketGroupInfo.setPrimingSocketNeeded(false);
            }
        } else {
            svrSocket = new MasterServerSocket(this.getServerSocketFactory(), bindPort, backlog, bindAddress);
        }
        log.debug("Created " + svrSocket.getClass() + ": " + svrSocket);
        return svrSocket;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public MultiplexServerInvoker getServerInvoker(InetSocketAddress address) {
        return (MultiplexServerInvoker)this.virtualServerInvokers.get(address);
    }

    public Collection getServerInvokers() {
        return this.virtualServerInvokers.values();
    }

    protected void setBindingInfo() throws IOException {
        String originalUri = this.getLocator().getOriginalURI();
        String pastProtocol = originalUri.substring(originalUri.indexOf("://") + 3);
        int colon = pastProtocol.indexOf(":");
        int slash = pastProtocol.indexOf("/");
        String originalHost = null;
        int originalPort = 0;
        if (colon != -1) {
            originalHost = pastProtocol.substring(0, colon).trim();
            originalPort = slash > -1 ? Integer.parseInt(pastProtocol.substring(colon + 1, slash)) : Integer.parseInt(pastProtocol.substring(colon + 1));
        } else {
            originalHost = slash > -1 ? pastProtocol.substring(0, slash).trim() : pastProtocol.substring(0).trim();
        }
        this.bindHost = this.getServerBindAddress();
        this.bindPort = this.getServerBindPort();
        this.bindAddress = InetAddress.getByName(this.bindHost);
    }

    protected SocketFactory createSocketFactory(Map configuration) throws IOException {
        if (configuration == null) {
            return null;
        }
        if (configuration.get("org.jboss.remoting.algorithm") != null || configuration.get("org.jboss.remoting.keyAlias") != null || configuration.get("org.jboss.remoting.keyStore") != null || configuration.get("org.jboss.remoting.keyStorePassword") != null || configuration.get("org.jboss.remoting.keyStoreType") != null || configuration.get("org.jboss.remoting.truststoreAlgorithm") != null || configuration.get("org.jboss.remoting.trustStore") != null || configuration.get("org.jboss.remoting.trustStorePassword") != null || configuration.get("org.jboss.remoting.trustStoreType") != null) {
            return new RemotingSSLSocketFactory(configuration);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SocketGroupInfo {
        private String socketGroupId;
        private Set clientInvokers = new HashSet();
        private MultiplexServerInvoker serverInvoker;
        private boolean primingSocketNeeded;
        private VirtualSocket primingSocket;
        private InetAddress connectAddress;
        private int connectPort;
        private InetAddress bindAddress;
        private int bindPort;

        public InetAddress getBindAddress() {
            return this.bindAddress;
        }

        public void setBindAddress(InetAddress bindAddress) {
            this.bindAddress = bindAddress;
        }

        public int getBindPort() {
            return this.bindPort;
        }

        public void setBindPort(int bindPort) {
            this.bindPort = bindPort;
        }

        public Set getClientInvokers() {
            return this.clientInvokers;
        }

        public void addClientInvoker(MultiplexClientInvoker clientInvoker) {
            this.clientInvokers.add(clientInvoker);
        }

        public void removeClientInvoker(MultiplexClientInvoker clientInvoker) {
            this.clientInvokers.remove(clientInvoker);
        }

        public InetAddress getConnectAddress() {
            return this.connectAddress;
        }

        public void setConnectAddress(InetAddress connectAddress) {
            this.connectAddress = connectAddress;
        }

        public int getConnectPort() {
            return this.connectPort;
        }

        public void setConnectPort(int connectPort) {
            this.connectPort = connectPort;
        }

        public boolean getPrimingSocketNeeded() {
            return this.primingSocketNeeded;
        }

        public void setPrimingSocketNeeded(boolean primingSocketNeeded) {
            this.primingSocketNeeded = primingSocketNeeded;
        }

        public VirtualSocket getPrimingSocket() {
            return this.primingSocket;
        }

        public void setPrimingSocket(VirtualSocket primingSocket) {
            this.primingSocket = primingSocket;
        }

        public String getSocketGroupId() {
            return this.socketGroupId;
        }

        public void setSocketGroupId(String socketGroupId) {
            this.socketGroupId = socketGroupId;
        }

        public MultiplexServerInvoker getServerInvoker() {
            return this.serverInvoker;
        }

        public void removeServerInvoker(MultiplexServerInvoker serverInvoker) {
            if (this.serverInvoker != serverInvoker) {
                String message = "Attempt to remove unknown MultiplexServerInvoker: (" + this.bindAddress + "," + this.bindPort + ")->(" + this.connectAddress + "," + this.connectPort + ")";
                log.error(message);
            }
            this.serverInvoker = null;
        }

        public void setServerInvoker(MultiplexServerInvoker serverInvoker) throws IOException {
            if (this.serverInvoker != null && serverInvoker != null) {
                String message = "Second MultiplexServerInvoker attempting to join invoker group: (" + this.bindAddress + "," + this.bindPort + ")->(" + this.connectAddress + "," + this.connectPort + ")";
                log.error(message);
                throw new IOException(message);
            }
            this.serverInvoker = serverInvoker;
        }
    }
}

