/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ejb.Container;
import org.jboss.ejb.EjbModule;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.logging.Logger;
import org.jboss.monitor.BeanCacheMonitorMBean;
import org.jboss.monitor.Monitorable;
import org.jboss.monitor.client.BeanCacheSnapshot;

public class BeanCacheMonitor
implements BeanCacheMonitorMBean,
MBeanRegistration {
    static Logger log = Logger.getLogger(BeanCacheMonitor.class);
    MBeanServer m_mbeanServer;

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.m_mbeanServer = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public BeanCacheSnapshot[] getSnapshots() {
        try {
            Collection snapshots = this.listSnapshots();
            BeanCacheSnapshot[] snapshotArray = new BeanCacheSnapshot[snapshots.size()];
            return snapshots.toArray(snapshotArray);
        }
        catch (JMException e) {
            log.error("Problem getting bean cache snapshots", e);
            return null;
        }
    }

    public Collection listSnapshots() throws JMException {
        ArrayList<BeanCacheSnapshot> cacheSnapshots = new ArrayList<BeanCacheSnapshot>();
        Set ejbModules = this.m_mbeanServer.queryNames(EjbModule.EJB_MODULE_QUERY_NAME, null);
        for (ObjectName ejbModule : ejbModules) {
            String name = ejbModule.getKeyProperty("jndiName");
            Collection containers = (Collection)this.m_mbeanServer.getAttribute(ejbModule, "Containers");
            Iterator cs = containers.iterator();
            while (cs.hasNext()) {
                InstanceCache cache = null;
                Object container = cs.next();
                if (container instanceof EntityContainer) {
                    cache = ((EntityContainer)container).getInstanceCache();
                } else if (container instanceof StatefulSessionContainer) {
                    cache = ((StatefulSessionContainer)container).getInstanceCache();
                }
                if (!(cache instanceof Monitorable)) continue;
                BeanCacheSnapshot snapshot = new BeanCacheSnapshot();
                snapshot.m_application = name;
                snapshot.m_container = ((Container)container).getBeanMetaData().getEjbName();
                ((Monitorable)((Object)cache)).sample(snapshot);
                cacheSnapshots.add(snapshot);
            }
        }
        return cacheSnapshots;
    }
}

