/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.deployment.DeploymentException;
import org.jboss.invocation.InvocationType;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class MethodMetaData
extends MetaData {
    public static final int ANY_METHOD = -1;
    public static String HOME_TYPE = "Home";
    public static String LOCAL_HOME_TYPE = "LocalHome";
    public static String REMOTE_TYPE = "Remote";
    public static String LOCAL_TYPE = "Local";
    public static String SERVICE_ENDPOINT_TYPE = "ServiceEndpoint";
    private static final ArrayList EMPTY_PARAM_LIST = new ArrayList();
    private String methodName;
    private String ejbName;
    private boolean intf = false;
    private InvocationType methodType = null;
    private boolean param = false;
    private boolean unchecked = false;
    private boolean excluded = false;
    private ArrayList paramList = EMPTY_PARAM_LIST;
    private byte transactionType;
    private Set roles = new HashSet();

    public String getMethodName() {
        return this.methodName;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public boolean isHomeMethod() {
        return this.methodType == InvocationType.HOME;
    }

    public boolean isRemoteMethod() {
        return this.methodType == InvocationType.REMOTE;
    }

    public boolean isLocalHomeMethod() {
        return this.methodType == InvocationType.LOCALHOME;
    }

    public boolean isLocalMethod() {
        return this.methodType == InvocationType.LOCAL;
    }

    public boolean isServiceEndpointMethod() {
        return this.methodType == InvocationType.SERVICE_ENDPOINT;
    }

    public String getInterfaceType() {
        String type = null;
        if (this.isHomeMethod()) {
            type = HOME_TYPE;
        }
        if (this.isLocalHomeMethod()) {
            type = LOCAL_HOME_TYPE;
        }
        if (this.isRemoteMethod()) {
            type = REMOTE_TYPE;
        }
        if (this.isLocalMethod()) {
            type = LOCAL_TYPE;
        }
        if (this.isServiceEndpointMethod()) {
            type = SERVICE_ENDPOINT_TYPE;
        }
        return type;
    }

    public boolean isUnchecked() {
        return this.unchecked;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public boolean isIntfGiven() {
        return this.intf;
    }

    public boolean isParamGiven() {
        return this.param;
    }

    public Iterator getParams() {
        return this.paramList.iterator();
    }

    public String[] getMethodParams() {
        String[] params = new String[this.paramList.size()];
        this.paramList.toArray(params);
        return params;
    }

    public byte getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(byte type) {
        this.transactionType = type;
    }

    public Set getRoles() {
        return this.roles;
    }

    public void setRoles(Set perm) {
        this.roles = perm;
    }

    public void setUnchecked() {
        this.unchecked = true;
    }

    public void setExcluded() {
        this.excluded = true;
    }

    public boolean patternMatches(String name, Class[] arg, InvocationType iface) {
        return this.patternMatches(name, MethodMetaData.getClassNames(arg), iface);
    }

    public boolean patternMatches(String name, String[] arg, InvocationType iface) {
        if (this.getMethodName().equals("*")) {
            return this.methodType == null || this.methodType == iface;
        }
        if (!this.getMethodName().equals(name)) {
            return false;
        }
        if (this.methodType != null && this.methodType != iface) {
            return false;
        }
        if (!this.isParamGiven()) {
            return true;
        }
        return this.sameParams(arg);
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        Element paramsElement;
        this.methodName = MethodMetaData.getElementContent(MethodMetaData.getUniqueChild(element, "method-name"));
        this.ejbName = MethodMetaData.getElementContent(MethodMetaData.getUniqueChild(element, "ejb-name"));
        Element intfElement = MethodMetaData.getOptionalChild(element, "method-intf");
        if (intfElement != null) {
            this.intf = true;
            String methodIntf = MethodMetaData.getElementContent(intfElement);
            if (methodIntf.equals("Home")) {
                this.methodType = InvocationType.HOME;
            } else if (methodIntf.equals("Remote")) {
                this.methodType = InvocationType.REMOTE;
            } else if (methodIntf.equals("LocalHome")) {
                this.methodType = InvocationType.LOCALHOME;
            } else if (methodIntf.equals("Local")) {
                this.methodType = InvocationType.LOCAL;
            } else if (methodIntf.equals("ServiceEndpoint")) {
                this.methodType = InvocationType.SERVICE_ENDPOINT;
            } else {
                throw new DeploymentException("method-intf tag should be one of: 'Home', 'Remote', 'LocalHome', 'Local', 'ServiceEndpoint'");
            }
        }
        if ((paramsElement = MethodMetaData.getOptionalChild(element, "method-params")) != null) {
            this.param = true;
            this.paramList = new ArrayList();
            Iterator paramsIterator = MethodMetaData.getChildrenByTagName(paramsElement, "method-param");
            while (paramsIterator.hasNext()) {
                this.paramList.add(MethodMetaData.getElementContent((Element)paramsIterator.next()));
            }
        }
    }

    private static String[] getClassNames(Class[] source) {
        String[] out = new String[source.length];
        for (int i = 0; i < out.length; ++i) {
            String brackets = "";
            Class<?> cls = source[i];
            while (cls.isArray()) {
                brackets = brackets + "[]";
                cls = cls.getComponentType();
            }
            out[i] = cls.getName() + brackets;
        }
        return out;
    }

    private boolean sameParams(String[] arg) {
        if (arg.length != this.paramList.size()) {
            return false;
        }
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i].equals(this.paramList.get(i))) continue;
            return false;
        }
        return true;
    }
}

