/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

public class ConfigureAction
extends KernelControllerContextAction {
    public void installAction(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        Object object = context.getTarget();
        BeanInfo info = context.getBeanInfo();
        BeanMetaData metaData = context.getBeanMetaData();
        Set<TargettedJoinpoint> joinPoints = configurator.getPropertySetterJoinPoints(info, metaData);
        this.setAttributes(context, object, joinPoints, false);
    }

    public void uninstallAction(KernelControllerContext context) {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        Object object = context.getTarget();
        BeanInfo info = context.getBeanInfo();
        BeanMetaData metaData = context.getBeanMetaData();
        try {
            Set<TargettedJoinpoint> joinPoints = configurator.getPropertyNullerJoinPoints(info, metaData);
            this.setAttributes(context, object, joinPoints, true);
        }
        catch (Throwable t) {
            this.log.warn("Error unconfiguring bean " + context, t);
        }
    }

    protected void setAttributes(KernelControllerContext context, Object target, Set joinPoints, boolean ignoreErrors) throws Throwable {
        if (!joinPoints.isEmpty()) {
            boolean trace = this.log.isTraceEnabled();
            for (TargettedJoinpoint joinPoint : joinPoints) {
                joinPoint.setTarget(target);
                try {
                    ConfigureAction.dispatchJoinPoint(context, joinPoint);
                }
                catch (Throwable t) {
                    if (ignoreErrors) {
                        if (!trace) continue;
                        this.log.trace("Ignored for " + joinPoint, t);
                        continue;
                    }
                    throw t;
                }
            }
        }
    }
}

