/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.ejb.EJBContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import org.jboss.ejb3.Container;
import org.jboss.injection.EJBContextFieldInjector;
import org.jboss.injection.EJBContextMethodInjector;
import org.jboss.injection.EnvEntryEncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiFieldInjector;
import org.jboss.injection.JndiMethodInjector;
import org.jboss.injection.LinkRefEncInjector;
import org.jboss.injection.TimerServiceFieldInjector;
import org.jboss.injection.TimerServiceMethodInjector;
import org.jboss.injection.UserTransactionFieldInjector;
import org.jboss.injection.UserTransactionMethodInjector;
import org.jboss.injection.ValueEncInjector;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.EnvEntry;
import org.jboss.metamodel.descriptor.EnvironmentRefGroup;
import org.jboss.metamodel.descriptor.MessageDestinationRef;
import org.jboss.metamodel.descriptor.ResourceEnvRef;
import org.jboss.metamodel.descriptor.ResourceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHandler
implements InjectionHandler {
    private static final Logger log = Logger.getLogger(ResourceHandler.class);

    private static void loadEnvEntry(InjectionContainer container, Collection<EnvEntry> envEntries) {
        for (EnvEntry envEntry : envEntries) {
            String encName = "env/" + envEntry.getEnvEntryName();
            InjectionUtil.injectionTarget(encName, envEntry, container, container.getEncInjections());
            if (container.getEncInjectors().containsKey(encName)) continue;
            container.getEncInjectors().put(encName, new EnvEntryEncInjector(encName, envEntry.getEnvEntryType(), envEntry.getEnvEntryValue()));
        }
    }

    private static void loadXmlResourceRefs(InjectionContainer container, Collection<ResourceRef> refs) {
        for (ResourceRef envRef : refs) {
            String encName = "env/" + envRef.getResRefName();
            if (container.getEncInjectors().containsKey(encName)) continue;
            if (envRef.getMappedName() == null || envRef.getMappedName().equals("")) {
                if (envRef.getResUrl() != null) {
                    try {
                        container.getEncInjectors().put(encName, new ValueEncInjector(encName, new URL(envRef.getResUrl().trim()), "<resource-ref>"));
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    throw new RuntimeException("mapped-name is required for " + envRef.getResRefName() + " of deployment " + container.getIdentifier());
                }
            }
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, envRef.getMappedName(), "<resource-ref>"));
            InjectionUtil.injectionTarget(encName, envRef, container, container.getEncInjections());
        }
    }

    private static void loadXmlResourceEnvRefs(InjectionContainer container, Collection<ResourceEnvRef> refs) {
        for (ResourceEnvRef envRef : refs) {
            String encName = "env/" + envRef.getResRefName();
            if (container.getEncInjectors().containsKey(encName)) continue;
            if (envRef.getMappedName() == null || envRef.getMappedName().equals("")) {
                throw new RuntimeException("mapped-name is required for " + envRef.getResRefName() + " of deployment " + container.getIdentifier());
            }
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, envRef.getMappedName(), "<resource-ref>"));
            InjectionUtil.injectionTarget(encName, envRef, container, container.getEncInjections());
        }
    }

    private static void loadXmlMessageDestinationRefs(InjectionContainer container, Collection<MessageDestinationRef> refs) {
        for (MessageDestinationRef envRef : refs) {
            String encName = "env/" + envRef.getMessageDestinationRefName();
            if (container.getEncInjectors().containsKey(encName)) continue;
            if (envRef.getMappedName() == null || envRef.getMappedName().equals("")) {
                String link = envRef.getMessageDestinationLink();
                if (link != null) {
                    // empty if block
                }
                throw new RuntimeException("mapped-name is required for " + envRef.getMessageDestinationRefName() + " of deployment " + container.getIdentifier());
            }
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, envRef.getMappedName(), "<message-destination-ref>"));
            InjectionUtil.injectionTarget(encName, envRef, container, container.getEncInjections());
        }
    }

    @Override
    public void loadXml(EnvironmentRefGroup xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        if (xml.getMessageDestinationRefs() != null) {
            ResourceHandler.loadXmlMessageDestinationRefs(container, xml.getMessageDestinationRefs());
        }
        if (xml.getResourceEnvRefs() != null) {
            ResourceHandler.loadXmlResourceEnvRefs(container, xml.getResourceEnvRefs());
        }
        if (xml.getResourceRefs() != null) {
            ResourceHandler.loadXmlResourceRefs(container, xml.getResourceRefs());
        }
        if (xml.getEnvEntries() != null) {
            ResourceHandler.loadEnvEntry(container, xml.getEnvEntries());
        }
    }

    @Override
    public void handleClassAnnotations(Class clazz, InjectionContainer container) {
        Resource res;
        Resources resources = container.getAnnotation(Resources.class, clazz);
        if (resources != null) {
            for (Resource ref : resources.value()) {
                this.handleClassAnnotation(ref, container, clazz);
            }
        }
        if ((res = container.getAnnotation(Resource.class, clazz)) != null) {
            this.handleClassAnnotation(res, container, clazz);
        }
    }

    private void handleClassAnnotation(Resource ref, InjectionContainer container, Class clazz) {
        String encName = ref.name();
        if (encName == null || encName.equals("")) {
            throw new RuntimeException("JBoss requires name() for class level @Resource");
        }
        encName = "env/" + ref.name();
        if (container.getEncInjectors().containsKey(encName)) {
            return;
        }
        String mappedName = ref.mappedName();
        if (mappedName == null || mappedName.equals("")) {
            throw new RuntimeException("You did not specify a @Resource.mappedName() on " + clazz.getName() + " and there is no binding for that enc name in XML");
        }
        container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.mappedName(), "@Resource"));
    }

    @Override
    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        Resource ref = method.getAnnotation(Resource.class);
        if (ref == null) {
            return;
        }
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(method) : "env/" + encName;
        method.setAccessible(true);
        if (!method.getName().startsWith("set")) {
            throw new RuntimeException("@Resource can only be used with a set method: " + method);
        }
        if (method.getParameterTypes().length != 1) {
            throw new RuntimeException("@Resource can only be used with a set method of one parameter: " + method);
        }
        Class type = method.getParameterTypes()[0];
        if (!ref.type().equals(Object.class)) {
            type = ref.type();
        }
        if (type.equals(UserTransaction.class)) {
            injectors.put(method, new UserTransactionMethodInjector(method, container));
        } else if (type.equals(TimerService.class)) {
            injectors.put(method, new TimerServiceMethodInjector(method, (Container)((Object)container)));
        } else if (EJBContext.class.isAssignableFrom(type)) {
            injectors.put(method, new EJBContextMethodInjector(method));
        } else if (type.equals(String.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Boolean.class) || type.equals(Double.class) || type.equals(Float.class) || type.isPrimitive()) {
            if (container.getEncInjectors().containsKey(encName)) {
                injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
            }
        } else {
            if (!container.getEncInjectors().containsKey(encName)) {
                String mappedName = ref.mappedName();
                if (mappedName == null || mappedName.equals("")) {
                    throw new RuntimeException("You did not specify a @Resource.mappedName() on " + method + " and there is no binding for that enc name in XML");
                }
                container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.mappedName(), "@Resource"));
            }
            injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
        }
    }

    @Override
    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        Resource ref = field.getAnnotation(Resource.class);
        if (ref == null) {
            return;
        }
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(field) : "env/" + encName;
        field.setAccessible(true);
        Class type = field.getType();
        if (!ref.type().equals(Object.class)) {
            type = ref.type();
        }
        if (type.equals(UserTransaction.class)) {
            injectors.put(field, new UserTransactionFieldInjector(field, container));
        } else if (type.equals(TimerService.class)) {
            injectors.put(field, new TimerServiceFieldInjector(field, (Container)((Object)container)));
        } else if (EJBContext.class.isAssignableFrom(type)) {
            injectors.put(field, new EJBContextFieldInjector(field));
        } else if (type.equals(String.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Boolean.class) || type.equals(Double.class) || type.equals(Float.class) || type.isPrimitive()) {
            if (container.getEncInjectors().containsKey(encName)) {
                injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
            }
        } else {
            if (!container.getEncInjectors().containsKey(encName)) {
                String mappedName = ref.mappedName();
                if (mappedName == null || mappedName.equals("")) {
                    throw new RuntimeException("You did not specify a @Resource.mappedName() on " + field + " and there is no binding for that enc name in XML");
                }
                container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.mappedName(), "@Resource"));
            }
            injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
        }
    }
}

