/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.bridge;

import java.lang.reflect.Field;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;

public class JDBCCMP1xFieldBridge
extends JDBCAbstractCMPFieldBridge {
    private Field field;

    public JDBCCMP1xFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata) throws DeploymentException {
        super(manager, metadata);
        try {
            this.field = manager.getMetaData().getEntityClass().getField(this.getFieldName());
        }
        catch (NoSuchFieldException e) {
            throw new DeploymentException("No field named '" + this.getFieldName() + "' found in entity class.");
        }
    }

    public Object getInstanceValue(EntityEnterpriseContext ctx) {
        FieldState fieldState = this.getFieldState(ctx);
        if (!fieldState.isLoaded()) {
            throw new EJBException("CMP 1.1 field not loaded: " + this.getFieldName());
        }
        try {
            return this.field.get(ctx.getInstance());
        }
        catch (Exception e) {
            throw new EJBException("Internal error getting instance field " + this.getFieldName(), e);
        }
    }

    public void setInstanceValue(EntityEnterpriseContext ctx, Object value) {
        try {
            this.field.set(ctx.getInstance(), value);
            FieldState fieldState = this.getFieldState(ctx);
            fieldState.setLoaded();
            fieldState.setCheckDirty();
        }
        catch (Exception e) {
            throw new EJBException("Internal error setting instance field " + this.getFieldName(), e);
        }
    }

    public Object getLockedValue(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException("Optimistic locking is not supported in CMP1.1.");
    }

    public void lockInstanceValue(EntityEnterpriseContext ctx) {
    }

    public boolean isLoaded(EntityEnterpriseContext ctx) {
        return this.getFieldState(ctx).isLoaded();
    }

    public boolean isDirty(EntityEnterpriseContext ctx) {
        if (this.isReadOnly() || this.isPrimaryKeyMember()) {
            return false;
        }
        return this.isLoaded(ctx) && !this.stateFactory.isStateValid(this.getInstanceValue(ctx), this.getFieldState(ctx).originalValue);
    }

    public void setClean(EntityEnterpriseContext ctx) {
        FieldState fieldState = this.getFieldState(ctx);
        fieldState.originalValue = this.getInstanceValue(ctx);
        if (this.isReadOnly()) {
            fieldState.lastRead = System.currentTimeMillis();
        }
    }

    public boolean isReadTimedOut(EntityEnterpriseContext ctx) {
        if (!this.isReadOnly()) {
            return true;
        }
        if (this.getReadTimeOut() == -1L) {
            return false;
        }
        long readInterval = System.currentTimeMillis() - this.getFieldState(ctx).lastRead;
        return readInterval >= this.getReadTimeOut();
    }

    public void resetPersistenceContext(EntityEnterpriseContext ctx) {
        JDBCContext jdbcCtx;
        FieldState fieldState;
        if (this.isReadTimedOut(ctx) && (fieldState = (FieldState)(jdbcCtx = (JDBCContext)ctx.getPersistenceContext()).getFieldState(this.jdbcContextIndex)) != null) {
            fieldState.reset();
        }
    }

    protected void setDirtyAfterGet(EntityEnterpriseContext ctx) {
        this.getFieldState(ctx).setCheckDirty();
    }

    private FieldState getFieldState(EntityEnterpriseContext ctx) {
        JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
        FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
        if (fieldState == null) {
            fieldState = new FieldState(jdbcCtx);
            jdbcCtx.setFieldState(this.jdbcContextIndex, fieldState);
        }
        return fieldState;
    }

    private class FieldState {
        private Object originalValue;
        private long lastRead = -1L;
        private JDBCEntityBridge.EntityState entityState;

        public FieldState(JDBCContext jdbcContext) {
            this.entityState = jdbcContext.getEntityState();
        }

        public boolean isLoaded() {
            return this.entityState.isLoaded(JDBCCMP1xFieldBridge.this.tableIndex);
        }

        public void setLoaded() {
            this.entityState.setLoaded(JDBCCMP1xFieldBridge.this.tableIndex);
        }

        public void setCheckDirty() {
            this.entityState.setCheckDirty(JDBCCMP1xFieldBridge.this.tableIndex);
        }

        public void reset() {
            this.originalValue = null;
            this.lastRead = -1L;
            this.entityState.resetFlags(JDBCCMP1xFieldBridge.this.tableIndex);
            JDBCCMP1xFieldBridge.this.log.debug("reset field state");
        }
    }
}

