/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.audit.AuditContext;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.authorization.EJBResource;
import org.jboss.system.Registry;

public class SecurityInterceptor
extends AbstractInterceptor {
    protected AuthenticationManager securityManager;
    protected AuthorizationManager authorizationManager;
    protected RealmMapping realmMapping;
    protected RunAsIdentity runAsIdentity;
    protected Map securityRoles;
    protected AuthenticationObserver authenticationObserver;
    protected Method ejbTimeout;
    protected String ejbName = null;
    protected CodeSource ejbCS = null;
    protected String appSecurityDomain = null;
    protected String defaultAuthorizationSecurityDomain = "jboss-ejb-policy";
    protected boolean addedSecurityContext = false;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            ApplicationMetaData applicationMetaData = beanMetaData.getApplicationMetaData();
            AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
            this.securityRoles = assemblyDescriptor.getSecurityRoles();
            SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
            if (secMetaData != null && !secMetaData.getUseCallerIdentity()) {
                String roleName = secMetaData.getRunAsRoleName();
                String principalName = secMetaData.getRunAsPrincipalName();
                Set extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
                this.runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
            }
            this.securityManager = container.getSecurityManager();
            this.realmMapping = container.getRealmMapping();
            this.authorizationManager = container.getAuthorizationManager();
            try {
                this.ejbTimeout = TimedObject.class.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            this.appSecurityDomain = applicationMetaData.getSecurityDomain();
            this.ejbName = beanMetaData.getEjbName();
            this.ejbCS = container.getBeanClass().getProtectionDomain().getCodeSource();
        }
    }

    public void start() throws Exception {
        super.start();
        this.authenticationObserver = (AuthenticationObserver)Registry.lookup("SecurityInterceptor.AuthenticationObserver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        this.checkSecurityContext();
        this.checkSecurityAssociation(mi);
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            Object object = returnValue = this.getNext().invokeHome(mi);
            return object;
        }
        finally {
            this.clearSecurityContext();
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Exception {
        this.checkSecurityContext();
        this.checkSecurityAssociation(mi);
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            Object object = returnValue = this.getNext().invoke(mi);
            return object;
        }
        finally {
            this.clearSecurityContext();
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
        }
    }

    private void checkSecurityAssociation(Invocation mi) throws Exception {
        boolean containerMethod;
        Principal principal = mi.getPrincipal();
        Object credential = mi.getCredential();
        boolean trace = this.log.isTraceEnabled();
        Method m = mi.getMethod();
        boolean bl = containerMethod = m == null || m.equals(this.ejbTimeout);
        if (containerMethod || this.securityManager == null || this.container == null) {
            SecurityActions.pushSubjectContext(principal, credential, null);
            return;
        }
        if (this.realmMapping == null) {
            throw new SecurityException("Role mapping manager has not been set");
        }
        RunAsIdentity callerRunAsIdentity = SecurityActions.peekRunAsIdentity();
        if (callerRunAsIdentity == null) {
            Subject subject = new Subject();
            if (!this.securityManager.isValid(principal, credential, subject)) {
                if (this.authenticationObserver != null) {
                    this.authenticationObserver.authenticationFailed();
                }
                Exception ex = SecurityActions.getContextException();
                this.errorAudit(principal, m.getName(), ex);
                if (ex != null) {
                    throw ex;
                }
                String msg = "Authentication exception, principal=" + principal;
                SecurityException e = new SecurityException(msg);
                this.failureAudit(principal, m.getName());
                throw e;
            }
            this.successAudit(principal, m.getName());
            SecurityActions.pushSubjectContext(principal, credential, subject);
            if (trace) {
                this.log.trace("Authenticated  principal=" + principal);
            }
        } else {
            SecurityActions.dupSubjectContext();
        }
        Method ejbMethod = mi.getMethod();
        if (ejbMethod == null) {
            return;
        }
        Subject caller = this.getContextCallerSubject();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ejb.name", this.ejbName);
        map.put("ejb.method", ejbMethod);
        map.put("ejb.principal", mi.getPrincipal());
        map.put("ejb.methodInterface", mi.getType().toInterfaceString());
        map.put("ejb.codeSource", this.ejbCS);
        map.put("caller.subject", caller);
        map.put("authorizationManager", this.authorizationManager);
        map.put("runAsIdentity", callerRunAsIdentity);
        map.put("ejb.methodRoles", this.container.getMethodPermissions(ejbMethod, mi.getType()));
        EJBResource ejbResource = new EJBResource(map);
        boolean isAuthorized = false;
        try {
            int check = this.authorizationManager.authorize(ejbResource);
            isAuthorized = check == 1;
            this.authorizationAudit(isAuthorized ? "Success" : "Failure", ejbResource, null);
        }
        catch (Exception e) {
            isAuthorized = false;
            if (trace) {
                this.log.trace("Error in authorization:", e);
            }
            this.authorizationAudit("Error", ejbResource, e);
        }
        String msg = "Denied: caller=" + caller;
        if (!isAuthorized) {
            throw new SecurityException(msg);
        }
    }

    private Subject getContextCallerSubject() throws PolicyContextException {
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        Subject caller = SecurityActions.getContextSubject();
        SecurityActions.popRunAsIdentity();
        return caller;
    }

    private void audit(String level, Map contextMap, Exception e) {
        contextMap.put("Source", this.getClass().getName());
        AuditContext ac = AuditManager.getAuditContext(this.securityManager.getSecurityDomain());
        AuditEvent ae = new AuditEvent(level);
        ae.setContextMap(contextMap);
        ae.setUnderlyingException(e);
        ac.audit(ae);
    }

    private void successAudit(Principal principal, String methodName) {
        this.audit("Success", this.getContextMap(principal, methodName), null);
    }

    private void failureAudit(Principal principal, String methodName) {
        this.audit("Failure", this.getContextMap(principal, methodName), null);
    }

    private void errorAudit(Principal principal, String methodName, Exception e) {
        this.audit("Error", this.getContextMap(principal, methodName), e);
    }

    private void authorizationAudit(String level, EJBResource resource, Exception e) {
        String exceptionMessage = e != null ? e.getLocalizedMessage() : "";
        HashMap<String, String> cmap = new HashMap<String, String>();
        cmap.putAll(resource.getMap());
        cmap.put("Exception:", exceptionMessage);
        this.audit(level, cmap, null);
    }

    private Map getContextMap(Principal principal, String methodName) {
        HashMap<String, Object> cmap = new HashMap<String, Object>();
        cmap.put("principal", principal);
        cmap.put("method", methodName);
        return cmap;
    }

    private void checkSecurityContext() {
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc == null) {
            SecurityActions.setSecurityContext(new SecurityContext());
            this.addedSecurityContext = true;
        }
    }

    private void clearSecurityContext() {
        if (this.addedSecurityContext) {
            SecurityActions.clearSecurityContext();
        }
    }

    public static interface AuthenticationObserver {
        public static final String KEY = "SecurityInterceptor.AuthenticationObserver";

        public void authenticationFailed();
    }
}

