/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.util.Set;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.security.RunAsIdentity;

public class RunAsSecurityInterceptor
extends AbstractInterceptor {
    protected RunAsIdentity runAsIdentity;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            ApplicationMetaData application = beanMetaData.getApplicationMetaData();
            AssemblyDescriptorMetaData assemblyDescriptor = application.getAssemblyDescriptor();
            SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
            if (secMetaData != null && !secMetaData.getUseCallerIdentity()) {
                String roleName = secMetaData.getRunAsRoleName();
                String principalName = secMetaData.getRunAsPrincipalName();
                if (principalName == null) {
                    principalName = application.getUnauthenticatedPrincipal();
                }
                Set extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
                this.runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
            }
        }
    }

    public void start() throws Exception {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            Object object = returnValue = this.getNext().invokeHome(mi);
            return object;
        }
        finally {
            SecurityActions.popRunAsIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Exception {
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            Object object = returnValue = this.getNext().invoke(mi);
            return object;
        }
        finally {
            SecurityActions.popRunAsIdentity();
        }
    }
}

