/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vdf.plugins.basic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.deployers.vdf.plugins.AbstractVDFComponent;
import org.jboss.deployers.vdf.plugins.basic.BasicComponentFactory;
import org.jboss.deployers.vdf.spi.VDFComponent;
import org.jboss.deployers.vdf.spi.VDFPathNameFilter;
import org.jboss.deployers.vdf.spi.VDFRuntimeException;
import org.jboss.logging.Logger;
import org.jboss.util.file.JarUtils;

public class BasicComponent
extends AbstractVDFComponent {
    private static final Logger slog = Logger.getLogger(BasicComponent.class);
    private BasicComponentFactory factory;
    private File file;
    private URL localURL;
    private URLClassLoader localCL;

    public BasicComponent(BasicComponentFactory factory, File file, URI uri) {
        super(uri, slog);
        this.file = file;
        this.factory = factory;
    }

    public String getBaseName() {
        return this.file.getName();
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public VDFComponent[] getChildren() {
        if (this.file.isDirectory()) {
            VDFComponent[] components = EMPTY_ARRAY;
            File[] files = this.file.listFiles();
            if (files.length > 0) {
                components = new VDFComponent[files.length];
                for (int i = 0; i < files.length; ++i) {
                    components[i] = new BasicComponent(this.factory, files[i], files[i].toURI());
                }
            }
            return components;
        }
        throw new VDFRuntimeException("Not a directory abstraction: " + this.uri);
    }

    public VDFComponent[] getChildrenRecursively(VDFPathNameFilter filter) {
        if (this.file.isFile()) {
            VDFComponent[] components = EMPTY_ARRAY;
            filter = filter != null ? filter : DEFAULT_FILTER;
            try {
                URL localURL = this.getLocalURL();
                JarFile jarFile = new JarFile(localURL.getFile());
                String jarURLPrefix = "jar:" + localURL.toString() + "!/";
                ArrayList<BasicComponent> results = new ArrayList<BasicComponent>(128);
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String pathname = entry.getName();
                    if (!filter.accept(pathname)) continue;
                    URL jarURL = new URL(jarURLPrefix + pathname);
                    URL nestedURL = JarUtils.extractNestedJar(jarURL, this.factory.getTmpDir());
                    URI nestedURI = new URI(nestedURL.toExternalForm());
                    this.log.debug("Extracted: " + nestedURI);
                    results.add(new BasicComponent(this.factory, new File(nestedURI), nestedURI));
                }
                if (!results.isEmpty()) {
                    components = results.toArray(new VDFComponent[results.size()]);
                }
            }
            catch (URISyntaxException e) {
                throw new VDFRuntimeException(e);
            }
            catch (IOException e) {
                throw new VDFRuntimeException(e);
            }
            return components;
        }
        throw new VDFRuntimeException("Not a packed file abstraction: " + this.uri);
    }

    public URL getLocalURL() {
        try {
            if (this.localURL == null) {
                File localFile;
                if (this.factory.isLocalCopyEnabled() && this.isFile() && this.factory.outsideLocalCopyDir(this.file)) {
                    localFile = File.createTempFile("tmp", this.getBaseName(), this.factory.getTmpDir());
                    this.log.debug("Copying " + this.uri + " --> " + localFile);
                    AbstractVDFComponent.copy(this.uri.toURL(), localFile);
                } else {
                    localFile = this.file;
                }
                this.localURL = localFile.toURL();
            }
            return this.localURL;
        }
        catch (IOException e) {
            throw new VDFRuntimeException(e);
        }
    }

    public URLClassLoader getLocalClassLoader() {
        if (this.localCL == null) {
            this.localCL = new URLClassLoader(new URL[]{this.getLocalURL()});
        }
        return this.localCL;
    }

    public Manifest getManifest() {
        return AbstractVDFComponent.getManifest(new File(this.getLocalURL().getFile()));
    }
}

