/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vdf.plugins;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jboss.deployers.vdf.spi.VDFComponentFactoryAdmin;
import org.jboss.deployers.vdf.spi.VDFRuntimeException;
import org.jboss.logging.Logger;
import org.jboss.util.JBossObject;
import org.jboss.util.file.Files;

public abstract class AbstractVDFComponentFactory
extends JBossObject
implements VDFComponentFactoryAdmin {
    public static final String LOCAL_COPY_FLAG_KEY = "jboss.deploy.localcopy";
    public static final String TMP_SUB_DIR_KEY = "jboss.deploy.tmpsubdir";
    public static final String SERVER_TMP_DIR_KEY = "jboss.server.temp.dir";
    protected Properties config;
    protected boolean localCopyEnabled;
    protected File tmpDir;

    public AbstractVDFComponentFactory() {
        this.log.trace("Constructing");
    }

    public AbstractVDFComponentFactory(Logger log) {
        super(log);
        log.trace("Constructing");
    }

    public void create(Properties config) throws VDFRuntimeException {
        if (config == null) {
            this.log.debug("No Properties supplied, using system properties");
            config = System.getProperties();
        }
        this.config = config;
        String localCopyString = config.getProperty(LOCAL_COPY_FLAG_KEY, "true");
        if (localCopyString.equalsIgnoreCase("false") || localCopyString.equalsIgnoreCase("no") || localCopyString.equalsIgnoreCase("off")) {
            this.log.debug("Disabling local copies");
            this.localCopyEnabled = false;
        } else {
            this.log.debug("Enabling local copies");
            this.localCopyEnabled = true;
        }
        String serverTmpDirString = config.getProperty(SERVER_TMP_DIR_KEY);
        if (serverTmpDirString == null) {
            serverTmpDirString = System.getProperty("java.io.tmpdir");
        }
        String tmpSubDir = config.getProperty(TMP_SUB_DIR_KEY, "deploy");
        this.tmpDir = new File(serverTmpDirString, tmpSubDir);
        Files.delete(this.tmpDir);
        this.tmpDir.mkdirs();
    }

    public void destroy() {
        this.config = null;
    }

    public boolean isLocalCopyEnabled() {
        return this.localCopyEnabled;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public boolean outsideLocalCopyDir(File file) {
        try {
            return !file.getCanonicalPath().startsWith(this.tmpDir.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }
}

