/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.util.JBossObject;
import org.jboss.vfs.spi.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentContext
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected VirtualFile file;
    protected DeploymentContext parent;
    protected Set<String> deploymentTypes = new CopyOnWriteArraySet<String>();
    protected List<String> classpath = new ArrayList<String>();
    protected List<DeploymentContext> subDeployments = new ArrayList<DeploymentContext>();
    protected ConcurrentHashMap<Serializable, Serializable> contextData = new ConcurrentHashMap();
    protected DeploymentState state = DeploymentState.CONSTRUCTED;

    public DeploymentContext() {
    }

    public DeploymentContext(VirtualFile file, DeploymentContext parent) {
        this.file = file;
        this.parent = parent;
    }

    public VirtualFile getFile() {
        return this.file;
    }

    public void setFile(VirtualFile file) {
        this.file = file;
    }

    public Map<Serializable, Serializable> getContextData() {
        return this.contextData;
    }

    public DeploymentContext getParentContext() {
        return this.parent;
    }

    public void setParentContext(DeploymentContext parent) {
        this.parent = parent;
    }

    public void setState(DeploymentState state) {
        this.state = state;
    }

    public DeploymentState getState() {
        return this.state;
    }

    public boolean addDeploymentType(String type) {
        return this.deploymentTypes.add(type);
    }

    public Set<String> getDeploymentTypes() {
        return this.deploymentTypes;
    }

    public boolean isDeploymentType(String type) {
        return this.deploymentTypes.contains(type);
    }

    public boolean isInClasspath(String path) {
        return this.classpath.contains(path);
    }

    public List<String> getClasspath() {
        return this.classpath;
    }

    public boolean addClasspathEntry(String path) {
        return this.classpath.add(path);
    }

    public boolean addSubDeployment(DeploymentContext child) {
        return this.subDeployments.add(child);
    }

    public List<DeploymentContext> getSubDeployments() {
        return new ArrayList<DeploymentContext>(this.subDeployments);
    }

    public void setSubDeployments(List<DeploymentContext> subDeployments) {
        if (subDeployments != null) {
            this.subDeployments.clear();
            this.subDeployments.addAll(subDeployments);
        }
    }

    public void toShortString(StringBuffer buffer) {
        buffer.append(super.getClassShortName());
    }

    protected void toString(StringBuffer buffer) {
        buffer.append(this.file.getPathName());
    }

    @Override
    protected int getHashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object other) {
        boolean equals = false;
        if (other instanceof DeploymentContext) {
            DeploymentContext dc = (DeploymentContext)other;
            equals = this.file.equals(dc.file);
        }
        return equals;
    }
}

