/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.bean;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.jboss.deployers.plugins.AbstractAspectDeployer;
import org.jboss.deployers.spi.DeploymentContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.vfs.spi.VirtualFile;

public class BeanDeployer
extends AbstractAspectDeployer {
    public static String[] ENHANCED_SUFFIXES = new String[]{"140:.beans", "150:-beans.xml"};
    public static String JAR_DESCRIPTOR = "META-INF/jboss-beans.xml";
    protected BasicXMLDeployer kernelDeployer;

    public BeanDeployer() {
        super(BeanDeployer.class.getName(), ENHANCED_SUFFIXES, 20);
    }

    public String getType() {
        return "beans";
    }

    public void start() throws Exception {
        try {
            this.kernelDeployer = new BasicXMLDeployer(this.context.getKernel());
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception("Failed to create BasicXMLDeployer", e);
        }
        super.start();
    }

    public void stop() {
        super.stop();
        this.kernelDeployer.shutdown();
    }

    public boolean analyze(DeploymentContext ctx) throws DeploymentException {
        boolean isBeanDeployment = false;
        String basename = ctx.getFile().getName();
        VirtualFile vf = ctx.getFile();
        if (this.endsWithOneOfTheSuffixes(basename)) {
            isBeanDeployment = true;
            try {
                VirtualFile descriptor = vf.findChild(JAR_DESCRIPTOR);
                this.log.debug("Found META-INF/jboss-beans.xml: " + descriptor);
                ctx.getContextData().put((Serializable)((Object)JAR_DESCRIPTOR), Boolean.TRUE);
                ctx.addClasspathEntry("");
            }
            catch (IOException ignore) {
                this.log.debug("No META-INF/jboss-beans.xml, assuming *-beans.xml");
            }
        }
        if (isBeanDeployment) {
            ctx.addDeploymentType(this.getType());
            this.log.debug("Found beans ctx: " + ctx.getFile());
        } else {
            this.log.debug("Skipping non-beans ctx: " + ctx.getFile());
        }
        return isBeanDeployment;
    }

    public Object getManagedObject(DeploymentContext ctx) {
        return null;
    }

    public void deploy(DeploymentContext ctx) throws DeploymentException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("Processing beans deployment: " + ctx);
        }
        VirtualFile descriptor = ctx.getFile();
        Boolean jarType = (Boolean)ctx.getContextData().get(JAR_DESCRIPTOR);
        try {
            if (jarType == Boolean.TRUE) {
                descriptor = ctx.getFile().findChild(JAR_DESCRIPTOR);
            }
            String name = ctx.toShortString();
            InputStream is = descriptor.openStream();
            this.kernelDeployer.deploy(name, is);
            is.close();
        }
        catch (Throwable e) {
            throw new DeploymentException("Failed deploy beans", e);
        }
    }

    public void redeploy(DeploymentContext ctx) throws DeploymentException {
        this.undeploy(ctx);
        this.deploy(ctx);
    }

    public void undeploy(DeploymentContext ctx) throws DeploymentException {
        String name = ctx.toShortString();
        this.kernelDeployer.undeploy(name);
    }
}

