/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins.factory;

import java.util.List;
import java.util.Map;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;

public class GenericBeanFactory {
    protected KernelConfigurator configurator;
    protected String bean;
    protected ClassLoaderMetaData classLoader;
    protected ConstructorMetaData constructor;
    protected Map properties;
    protected LifecycleMetaData create;
    protected LifecycleMetaData start;

    public GenericBeanFactory(KernelConfigurator configurator) {
        this.configurator = configurator;
    }

    public Object createBean() throws Throwable {
        ClassLoader cl = Configurator.getClassLoader(this.classLoader);
        BeanInfo info = this.configurator.getBeanInfo(this.bean, cl);
        Joinpoint joinpoint = this.configurator.getConstructorJoinPoint(info, this.constructor, null);
        Object result = joinpoint.dispatch();
        if (this.properties != null && this.properties.size() > 0) {
            for (Map.Entry entry : this.properties.entrySet()) {
                String property = (String)entry.getKey();
                ValueMetaData vmd = (ValueMetaData)entry.getValue();
                TargettedJoinpoint jp = this.configurator.getPropertySetterJoinPoint(info, property, cl, vmd);
                jp.setTarget(result);
                jp.dispatch();
            }
        }
        this.invokeLifecycle("create", this.create, info, cl, result);
        this.invokeLifecycle("start", this.start, info, cl, result);
        return result;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    public ConstructorMetaData getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ConstructorMetaData constructor) {
        this.constructor = constructor;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public LifecycleMetaData getCreate() {
        return this.create;
    }

    public void setCreate(LifecycleMetaData create) {
        this.create = create;
    }

    public LifecycleMetaData getStart() {
        return this.start;
    }

    public void setStart(LifecycleMetaData start) {
        this.start = start;
    }

    protected void invokeLifecycle(String methodName, LifecycleMetaData lifecycle, BeanInfo info, ClassLoader cl, Object target) throws Throwable {
        String method = methodName;
        if (lifecycle != null) {
            method = lifecycle.getMethodName();
        }
        List<ParameterMetaData> parameters = null;
        if (lifecycle != null) {
            parameters = lifecycle.getParameters();
        }
        MethodJoinpoint joinpoint = null;
        try {
            joinpoint = this.configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
        }
        catch (JoinpointException ignored) {
            return;
        }
        joinpoint.setTarget(target);
        joinpoint.dispatch();
    }
}

