/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.txlock;

import java.util.HashMap;
import java.util.LinkedList;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.logging.Logger;
import org.jboss.util.deadlock.DeadlockDetector;
import org.jboss.util.deadlock.Resource;

public class QueuedTxLock
implements Resource {
    public static final String TXLOCK = "TxLock";
    public static final String TIMEOUT = "timeout";
    private HashMap txLocks = new HashMap();
    private LinkedList txWaitQueue = new LinkedList();
    private Transaction tx = null;
    private boolean synched = false;
    private boolean isSynchronized = false;
    private Logger log = Logger.getLogger(this.getClass());

    public Object getResourceHolder() {
        return this.tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws InterruptedException {
        QueuedTxLock queuedTxLock = this;
        synchronized (queuedTxLock) {
            while (this.synched) {
                this.wait();
            }
            this.synched = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSync() {
        QueuedTxLock queuedTxLock = this;
        synchronized (queuedTxLock) {
            this.synched = false;
            this.notify();
        }
    }

    public void setTransaction(Transaction tx) {
        this.tx = tx;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    protected TxLock getTxLock(Transaction miTx) {
        TxLock lock = null;
        TxLock key = new TxLock(miTx);
        lock = (TxLock)this.txLocks.get(key);
        if (lock == null) {
            this.txLocks.put(key, key);
            this.txWaitQueue.addLast(key);
            lock = key;
        }
        return lock;
    }

    protected boolean isTxExpired(Transaction miTx) throws Exception {
        return miTx != null && miTx.getStatus() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockNoWait(Transaction transaction) throws Exception {
        this.sync();
        if (this.log.isTraceEnabled()) {
            this.log.trace("lockNoWait tx=" + transaction + " " + this.toString());
        }
        try {
            if (this.getTransaction() != null && !this.getTransaction().equals(transaction)) {
                boolean bl = false;
                return bl;
            }
            this.setTransaction(transaction);
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Transaction miTx, Invocation mi) throws Exception {
        boolean trace = this.log.isTraceEnabled();
        this.sync();
        try {
            if (trace) {
                this.log.trace("Begin schedule");
            }
            if (this.isTxExpired(miTx)) {
                this.log.error("Saw rolled back tx=" + miTx);
                throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
            }
            this.waitForTx(mi, miTx, trace);
            if (!this.isSynchronized) {
                this.isSynchronized = true;
                miTx.registerSynchronization(new TxLockSynchronization());
            }
        }
        finally {
            this.releaseSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForTx(Invocation mi, Transaction miTx, boolean trace) throws Exception {
        boolean wasScheduled = false;
        TxLock txLock = null;
        while (this.getTransaction() != null && !this.getTransaction().equals(miTx)) {
            try {
                DeadlockDetector.singleton.deadlockDetection(miTx, this);
            }
            catch (Exception e) {
                if (txLock != null && txLock.isQueued) {
                    this.txLocks.remove(txLock);
                    this.txWaitQueue.remove(txLock);
                }
                throw e;
            }
            wasScheduled = true;
            if (trace) {
                this.log.trace("Transactional contention on context miTx=" + miTx + " " + this.toString());
            }
            if (txLock == null) {
                txLock = this.getTxLock(miTx);
            }
            if (trace) {
                this.log.trace("Begin wait on " + txLock + " " + this.toString());
            }
            TxLock txLock2 = txLock;
            synchronized (txLock2) {
                this.releaseSync();
                try {
                    int txTimeout = 0;
                    Integer timeout = (Integer)mi.getMetaData(TXLOCK, TIMEOUT);
                    if (timeout != null) {
                        txTimeout = timeout;
                    }
                    txLock.wait(txTimeout);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            this.sync();
            if (trace) {
                this.log.trace("End wait on " + txLock + " " + this.toString());
            }
            if (!this.isTxExpired(miTx)) continue;
            this.log.error(Thread.currentThread() + "Saw rolled back tx=" + miTx + " waiting for txLock");
            if (txLock.isQueued) {
                this.txLocks.remove(txLock);
                this.txWaitQueue.remove(txLock);
            } else if (this.getTransaction() != null && this.getTransaction().equals(miTx)) {
                this.nextTransaction(trace);
            }
            if (miTx != null) {
                DeadlockDetector.singleton.removeWaiting(miTx);
            }
            throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
        }
        if (!wasScheduled) {
            this.setTransaction(miTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nextTransaction(boolean trace) {
        if (!this.synched) {
            throw new IllegalStateException("do not call nextTransaction while not synched!");
        }
        this.setTransaction(null);
        TxLock thelock = null;
        if (!this.txWaitQueue.isEmpty()) {
            thelock = (TxLock)this.txWaitQueue.removeFirst();
            this.txLocks.remove(thelock);
            thelock.isQueued = false;
            if (thelock.waitingTx != null) {
                DeadlockDetector.singleton.removeWaiting(thelock.waitingTx);
            }
            this.setTransaction(thelock.waitingTx);
            TxLock txLock = thelock;
            synchronized (txLock) {
                thelock.notifyAll();
            }
        }
        if (trace) {
            this.log.trace("nextTransaction: " + thelock + " " + this.toString());
        }
    }

    public void endTransaction() {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("endTransaction: " + this.toString());
        }
        this.nextTransaction(trace);
    }

    public void endInvocation(Transaction thetx) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("endInvocation: miTx=" + thetx + " " + this.toString());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(" hash=").append(this.hashCode());
        buffer.append(" tx=").append(this.getTransaction());
        buffer.append(" synched=").append(this.synched);
        buffer.append(" queue=").append(this.txWaitQueue);
        return buffer.toString();
    }

    private final class TxLockSynchronization
    implements Synchronization {
        private TxLockSynchronization() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                QueuedTxLock.this.sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            QueuedTxLock.this.isSynchronized = false;
            QueuedTxLock.this.endTransaction();
            QueuedTxLock.this.releaseSync();
        }
    }

    private class TxLock {
        public Transaction waitingTx;
        public String threadName = Thread.currentThread().toString();
        public boolean isQueued;

        public TxLock(Transaction trans) {
            this.waitingTx = trans;
            this.isQueued = true;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            TxLock lock = (TxLock)obj;
            return lock.waitingTx.equals(this.waitingTx);
        }

        public int hashCode() {
            return this.waitingTx.hashCode();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append("TXLOCK waitingTx=").append(this.waitingTx);
            buffer.append(" thread=").append(this.threadName);
            buffer.append(" queued=").append(this.isQueued);
            return buffer.toString();
        }
    }
}

