/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.util.WeakHashMap;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.proxy.container.AOPProxyFactoryMixin;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyCacheKey;
import org.jboss.aop.proxy.container.InstanceProxyContainer;
import org.jboss.aop.proxy.container.ProxyAdvisorDomain;
import org.jboss.repository.spi.MetaDataContext;

public class ContainerCache {
    private static volatile int counter;
    public static final Object mapLock;
    private static WeakHashMap containerCache;
    private AspectManager manager;
    private ContainerProxyCacheKey key;
    private Advisor classAdvisor;
    private InstanceProxyContainer instanceContainer;
    boolean isClassProxyContainer;
    Class[] interfaces;
    AOPProxyFactoryMixin[] mixins;
    MetaDataContext metaDataContext;
    SimpleMetaData simpleMetaData;

    private ContainerCache(AspectManager manager, Class proxiedClass, Class[] interfaces, AOPProxyFactoryMixin[] mixins, MetaDataContext metaDataContext, SimpleMetaData simpleMetaData) {
        this.manager = manager;
        this.interfaces = interfaces;
        this.mixins = mixins;
        this.metaDataContext = metaDataContext;
        this.simpleMetaData = simpleMetaData;
        this.key = new ContainerProxyCacheKey(proxiedClass, interfaces, mixins, metaDataContext);
    }

    public static ContainerCache initialise(AspectManager manager, Class proxiedClass, MetaDataContext metaDataContext) {
        return ContainerCache.initialise(manager, proxiedClass, null, null, metaDataContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContainerCache initialise(AspectManager manager, Class proxiedClass, Class[] interfaces, AOPProxyFactoryMixin[] mixins, MetaDataContext metaDataContext, SimpleMetaData simpleMetaData) {
        ContainerCache factory = new ContainerCache(manager, proxiedClass, interfaces, mixins, metaDataContext, simpleMetaData);
        Object object = mapLock;
        synchronized (object) {
            factory.initClassContainer();
            factory.initInstanceContainer();
        }
        return factory;
    }

    public ContainerProxyCacheKey getKey() {
        return this.key;
    }

    public Advisor getAdvisor() {
        return this.instanceContainer != null ? this.instanceContainer : this.classAdvisor;
    }

    public Advisor getClassAdvisor() {
        return this.classAdvisor;
    }

    public InstanceProxyContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public boolean hasAspects() {
        if (this.instanceContainer != null) {
            return this.instanceContainer.hasAspects();
        }
        return this.classAdvisor.hasAspects();
    }

    public boolean requiresInstanceAdvisor() {
        return this.hasInterfaceIntroductions() || this.hasMixins() || this.metaDataContext != null || this.simpleMetaData != null;
    }

    public boolean isAdvised() {
        return Advised.class.isAssignableFrom(this.key.getClazz());
    }

    private boolean hasInterfaceIntroductions() {
        return this.interfaces != null && this.interfaces.length > 0;
    }

    private boolean hasMixins() {
        return this.mixins != null && this.mixins.length > 0;
    }

    private void initClassContainer() {
        if (Advised.class.isAssignableFrom(this.key.getClazz())) {
            this.classAdvisor = AspectManager.instance().getAdvisor(this.key.getClazz());
        } else {
            this.classAdvisor = this.getCachedContainer(this.manager);
            if (this.classAdvisor == null) {
                this.classAdvisor = this.createAndCacheContainer();
            }
        }
    }

    private ClassProxyContainer getCachedContainer(AspectManager manager) {
        return (ClassProxyContainer)containerCache.get(this.key.getClazz());
    }

    private ClassProxyContainer createAndCacheContainer() {
        ClassProxyContainer container = this.createContainer();
        this.cacheContainer(this.key, this.key.getClazz(), container);
        return container;
    }

    private ClassProxyContainer createContainer() {
        ProxyAdvisorDomain domain = new ProxyAdvisorDomain(this.manager, this.key.getClazz(), false);
        String classname = this.key.getClazz() != null ? this.key.getClazz().getName() : "AOP$Hollow";
        ClassProxyContainer container = new ClassProxyContainer(classname, domain);
        domain.setAdvisor(container);
        container.initialise(this.key.getClazz());
        return container;
    }

    private void cacheContainer(ContainerProxyCacheKey key, Class proxiedClass, ClassProxyContainer container) {
        containerCache.put(proxiedClass, container);
    }

    private InterfaceIntroduction getInterfaceIntroduction() {
        int mixinLength;
        int introductionLength = this.hasInterfaceIntroductions() ? this.interfaces.length : 0;
        int n = mixinLength = this.hasMixins() ? this.mixins.length : 0;
        if (introductionLength == 0 && mixinLength == 0) {
            return null;
        }
        Class proxiedClass = this.classAdvisor.getClazz();
        Class clazz = proxiedClass != null ? proxiedClass : Object.class;
        String[] introducedNames = this.getClassNames(this.interfaces);
        InterfaceIntroduction intro = new InterfaceIntroduction("Introduction" + counter++, clazz.getName(), introducedNames);
        if (mixinLength > 0) {
            this.addMixins(intro);
        }
        return intro;
    }

    private void addMixins(InterfaceIntroduction intro) {
        for (int i = 0; i < this.mixins.length && this.mixins != null; ++i) {
            Class[] mixinInterfaces = this.mixins[i].getInterfaces();
            Class mixinClass = this.mixins[i].getMixin();
            if (mixinInterfaces == null) {
                throw new RuntimeException("When defining a mixin, interfaces must be defined");
            }
            if (mixinClass == null) {
                throw new RuntimeException("When defining a mixin, the mixin must be defined");
            }
            String[] mixinInterfaceNames = this.getClassNames(mixinInterfaces);
            InterfaceIntroduction.Mixin mixin = new InterfaceIntroduction.Mixin(mixinClass.getName(), mixinInterfaceNames, this.mixins[i].getConstruction(), false);
            intro.addMixin(mixin);
        }
    }

    private String[] getClassNames(Class[] classes) {
        if (classes == null) {
            return null;
        }
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = classes[i].getName();
        }
        return names;
    }

    private void initInstanceContainer() {
        if (this.requiresInstanceAdvisor()) {
            InterfaceIntroduction introduction = null;
            if (this.hasInterfaceIntroductions() || this.hasMixins()) {
                introduction = this.getInterfaceIntroduction();
            }
            this.instanceContainer = InstanceProxyContainer.createInstanceProxyContainer(this.classAdvisor, introduction, this.metaDataContext);
        }
    }

    static {
        mapLock = new Object();
        containerCache = new WeakHashMap();
    }
}

