/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    SecurityActions() {
    }

    static Class loadClass(String name) {
        if (System.getSecurityManager() == null) {
            return LoadClassAction.NON_PRIVILEGED.loadClass(name);
        }
        return LoadClassAction.PRIVILEGED.loadClass(name);
    }

    static interface LoadClassAction {
        public static final LoadClassAction PRIVILEGED = new LoadClassAction(){

            public Class loadClass(final String name) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return Thread.currentThread().getContextClassLoader().loadClass(name);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(name, e);
                }
            }
        };
        public static final LoadClassAction NON_PRIVILEGED = new LoadClassAction(){

            public Class loadClass(String name) {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        public Class loadClass(String var1);
    }
}

