/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.deployment.JBossClassPool;
import org.jboss.mx.loading.RepositoryClassLoader;

public class JBossClassPoolFactory
implements ScopedClassPoolFactory {
    protected File tmpClassesDir;

    public JBossClassPoolFactory(File tmpClassesDir) throws IOException {
        this.tmpClassesDir = tmpClassesDir;
    }

    public ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        try {
            if (cl instanceof RepositoryClassLoader) {
                File tempdir = this.createTempDir(cl);
                return new JBossClassPool(cl, src, repository, tempdir);
            }
            return new AOPClassPool(cl, src, repository);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ScopedClassPool create(ClassPool src, ScopedClassPoolRepository repository) {
        return new JBossClassPool(src, repository);
    }

    public File createTempDir(ClassLoader cl) throws IOException {
        File tempdir = File.createTempFile("ucl", "", this.tmpClassesDir);
        tempdir.delete();
        tempdir.mkdir();
        tempdir.deleteOnExit();
        RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
        URL tmpURL = tempdir.toURL();
        URL tmpCP = new URL(tmpURL, "?dynamic=true");
        if (ucl.getLoaderRepository() != null) {
            ucl.addURL(tmpCP);
        }
        return tempdir;
    }
}

