/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.jboss.annotation.factory.javassist.AnnotationProxy;
import org.jboss.aop.AnnotationIntroductionDef;
import org.jboss.aop.Aspect;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Bind;
import org.jboss.aop.CFlowDef;
import org.jboss.aop.CFlowStackDef;
import org.jboss.aop.DeclareError;
import org.jboss.aop.DeclareWarning;
import org.jboss.aop.DynamicCFlowDef;
import org.jboss.aop.InterceptorDef;
import org.jboss.aop.PointcutDef;
import org.jboss.aop.Precedence;
import org.jboss.aop.PrecedenceAdvice;
import org.jboss.aop.Prepare;
import org.jboss.aop.TypeDef;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactoryDelegator;
import org.jboss.aop.advice.AspectFactoryWithClassLoaderSupport;
import org.jboss.aop.advice.DynamicCFlowDefinition;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PrecedenceDef;
import org.jboss.aop.advice.PrecedenceDefEntry;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopedInterceptorFactory;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.pointcut.CFlow;
import org.jboss.aop.pointcut.CFlowStack;
import org.jboss.aop.pointcut.DeclareDef;
import org.jboss.aop.pointcut.DynamicCFlow;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.TypedefExpression;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.pointcut.ast.TypeExpressionParser;
import org.jboss.aop.util.MethodHashing;

public class AspectAnnotationLoader {
    protected AspectManager manager;
    static /* synthetic */ Class class$org$jboss$aop$advice$AspectFactory;
    static /* synthetic */ Class class$org$jboss$aop$advice$Interceptor;
    static /* synthetic */ Class class$org$jboss$aop$PrecedenceInterceptor;
    static /* synthetic */ Class class$org$jboss$aop$PrecedenceAdvice;
    static /* synthetic */ Class class$org$jboss$aop$PointcutDef;
    static /* synthetic */ Class class$org$jboss$aop$Mixin;
    static /* synthetic */ Class class$org$jboss$aop$Introduction;
    static /* synthetic */ Class class$org$jboss$aop$TypeDef;
    static /* synthetic */ Class class$org$jboss$aop$CFlowStackDef;
    static /* synthetic */ Class class$org$jboss$aop$AnnotationIntroductionDef;
    static /* synthetic */ Class class$org$jboss$aop$DeclareWarning;
    static /* synthetic */ Class class$org$jboss$aop$DeclareError;

    public AspectAnnotationLoader(AspectManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployInputStreamIterator(Iterator it) throws Exception {
        while (it.hasNext()) {
            InputStream stream = (InputStream)it.next();
            DataInputStream dstream = new DataInputStream(stream);
            ClassFile cf = null;
            try {
                cf = new ClassFile(dstream);
            }
            finally {
                dstream.close();
                stream.close();
            }
            this.deployClassFile(cf);
        }
    }

    public void deployClassFile(ClassFile cf) throws Exception {
        AnnotationsAttribute visible;
        if (AspectManager.verbose) {
            System.out.println("[debug] Looking for aspects in: " + cf.getName());
        }
        if ((visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations")) != null) {
            AspectDefinition def = this.deployAspect(visible, cf);
            if (def == null) {
                def = this.deployInterceptor(visible, cf);
            }
            if (def == null) {
                this.deployDynamicCFlow(visible, cf);
            }
            if (def == null) {
                if (!this.deployPreparedClass(visible, cf)) {
                    this.deployPrecedence(visible, cf);
                }
            } else {
                this.deployPointcuts(cf);
                this.deployMixins(cf);
                this.deployIntroductions(cf);
                this.deployTypedefs(cf);
                this.deployCFlowStackDefs(cf);
                this.deployPrepares(cf);
                this.deployAnnotationIntroductions(cf);
                this.deployDeclares(cf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployInputStreamIterator(Iterator it) throws Exception {
        while (it.hasNext()) {
            InputStream stream = (InputStream)it.next();
            DataInputStream dstream = new DataInputStream(stream);
            ClassFile cf = null;
            try {
                cf = new ClassFile(dstream);
            }
            finally {
                dstream.close();
                stream.close();
            }
            this.undeployClassFile(cf);
        }
    }

    public void undeployClassFile(ClassFile cf) throws Exception {
        AnnotationsAttribute visible;
        if (AspectManager.verbose) {
            System.out.println("[debug] Looking for aspects in: " + cf.getName());
        }
        if ((visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations")) != null) {
            this.undeployAspect(visible, cf);
            this.undeployInterceptor(visible, cf);
            this.undeployDynamicCFlow(visible, cf);
            this.undeployPreparedClass(visible, cf);
            this.undeployPrecedence(visible, cf);
            this.undeployPointcuts(cf);
            this.undeployMixins(cf);
            this.undeployIntroductions(cf);
            this.undeployTypedefs(cf);
            this.undeployCFlowStackDefs(cf);
            this.undeployPrepares(cf);
            this.undeployAnnotationIntroductions(cf);
        }
    }

    private AspectDefinition deployAspect(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Aspect.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Found @Aspect in: " + cf.getName());
            }
            Aspect aspect = (Aspect)AnnotationProxy.createProxy(info, Aspect.class);
            Scope scope = aspect.scope();
            String[] interfaces = cf.getInterfaces();
            boolean isFactory = false;
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].equals((class$org$jboss$aop$advice$AspectFactory == null ? AspectAnnotationLoader.class$("org.jboss.aop.advice.AspectFactory") : class$org$jboss$aop$advice$AspectFactory).getName())) continue;
                isFactory = true;
                break;
            }
            AspectFactoryWithClassLoaderSupport factory = null;
            factory = isFactory ? new AspectFactoryDelegator(cf.getName(), null) : new GenericAspectFactory(cf.getName(), null);
            AspectDefinition def = new AspectDefinition(cf.getName(), scope, factory);
            this.manager.addAspectDefinition(def);
            if (!isFactory) {
                this.deployAspectMethodBindings(cf, def);
            }
            return def;
        }
        return null;
    }

    private void undeployAspect(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Aspect.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Undeploying @Aspect in: " + cf.getName());
            }
            this.manager.removeAspectDefinition(cf.getName());
            this.undeployAspectMethodBindings(cf);
        }
    }

    private AspectDefinition deployInterceptor(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(InterceptorDef.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Found @InterceptorDef in: " + cf.getName());
            }
            Aspect aspect = (Aspect)AnnotationProxy.createProxy(info, Aspect.class);
            Scope scope = aspect.scope();
            String[] interfaces = cf.getInterfaces();
            boolean isFactory = false;
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].equals((class$org$jboss$aop$advice$AspectFactory == null ? AspectAnnotationLoader.class$("org.jboss.aop.advice.AspectFactory") : class$org$jboss$aop$advice$AspectFactory).getName())) {
                    isFactory = true;
                    break;
                }
                if (interfaces[i].equals((class$org$jboss$aop$advice$Interceptor == null ? AspectAnnotationLoader.class$("org.jboss.aop.advice.Interceptor") : class$org$jboss$aop$advice$Interceptor).getName())) break;
            }
            AspectFactoryWithClassLoaderSupport aspectFactory = isFactory ? new AspectFactoryDelegator(cf.getName(), null) : new GenericAspectFactory(cf.getName(), null);
            AspectDefinition def = new AspectDefinition(cf.getName(), scope, aspectFactory);
            this.manager.addAspectDefinition(def);
            ScopedInterceptorFactory factory = new ScopedInterceptorFactory(def);
            this.manager.addInterceptorFactory(factory.getName(), factory);
            this.deployInterceptorBindings(visible, cf, factory);
            return def;
        }
        return null;
    }

    private void undeployInterceptor(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(InterceptorDef.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Undeploying @InterceptorDef in: " + cf.getName());
            }
            AnnotationProxy.createProxy(info, Aspect.class);
            this.manager.removeAspectDefinition(cf.getName());
            this.manager.removeInterceptorFactory(cf.getName());
            this.undeployInterceptorBindings(visible, cf);
        }
    }

    private void deployDynamicCFlow(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(DynamicCFlowDef.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Found @DynamicCFlowDef in: " + cf.getName());
            }
            AnnotationProxy.createProxy(info, DynamicCFlowDef.class);
            String name = cf.getName();
            String clazz = cf.getName();
            String[] interfaces = cf.getInterfaces();
            boolean foundDCFlow = false;
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].equals((class$org$jboss$aop$pointcut$DynamicCFlow == null ? AspectAnnotationLoader.class$("org.jboss.aop.pointcut.DynamicCFlow") : class$org$jboss$aop$pointcut$DynamicCFlow).getName())) continue;
                foundDCFlow = true;
                break;
            }
            if (!foundDCFlow) {
                throw new RuntimeException("@DynamicCFlow annotated class: " + clazz + " must implement " + DynamicCFlow.class.getName());
            }
            this.manager.addDynamicCFlow(name, new DynamicCFlowDefinition(null, clazz, name));
        }
    }

    private void undeployDynamicCFlow(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(DynamicCFlowDef.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Undeploying @DynamicCFlowDef in: " + cf.getName());
            }
            String name = cf.getName();
            this.manager.removeDynamicCFlow(name);
        }
    }

    private boolean deployPreparedClass(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Prepare.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Found top-level @Prepare in: " + cf.getName());
            }
            Prepare prepare = (Prepare)AnnotationProxy.createProxy(info, Prepare.class);
            String name = cf.getName() + "." + visible.getName();
            String expr = AspectAnnotationLoader.replaceThisInExpr(prepare.value(), cf.getName());
            PointcutExpression p = new PointcutExpression(name, expr);
            this.manager.addPointcut(p);
            return true;
        }
        return false;
    }

    private void undeployPreparedClass(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Prepare.class.getName());
        if (info != null) {
            String name = cf.getName() + "." + visible.getName();
            this.manager.removePointcut(name);
        }
    }

    private void deployPrecedence(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Precedence.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Found top-level @Precedence in: " + cf.getName());
            }
            ArrayList<PrecedenceDefEntry> entries = new ArrayList<PrecedenceDefEntry>();
            Iterator fields = cf.getFields().iterator();
            while (fields.hasNext()) {
                FieldInfo finfo = (FieldInfo)fields.next();
                AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
                if (mgroup == null) continue;
                Annotation binfo = mgroup.getAnnotation((class$org$jboss$aop$PrecedenceInterceptor == null ? AspectAnnotationLoader.class$("org.jboss.aop.PrecedenceInterceptor") : class$org$jboss$aop$PrecedenceInterceptor).getName());
                if (binfo != null) {
                    entries.add(new PrecedenceDefEntry(this.getFieldType(finfo), null));
                    continue;
                }
                binfo = mgroup.getAnnotation((class$org$jboss$aop$PrecedenceAdvice == null ? AspectAnnotationLoader.class$("org.jboss.aop.PrecedenceAdvice") : class$org$jboss$aop$PrecedenceAdvice).getName());
                if (binfo == null) continue;
                PrecedenceAdvice advice = (PrecedenceAdvice)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$PrecedenceAdvice == null ? AspectAnnotationLoader.class$("org.jboss.aop.PrecedenceAdvice") : class$org$jboss$aop$PrecedenceAdvice);
                String method = advice.value();
                entries.add(new PrecedenceDefEntry(this.getFieldType(finfo), method));
            }
            PrecedenceDefEntry[] pentries = entries.toArray(new PrecedenceDefEntry[entries.size()]);
            PrecedenceDef precedenceDef = new PrecedenceDef(cf.getName(), pentries);
            this.manager.addPrecedence(precedenceDef);
        }
    }

    private void undeployPrecedence(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Precedence.class.getName());
        if (info != null) {
            this.manager.removePrecedence(cf.getName());
        }
    }

    private void deployAspectMethodBindings(ClassFile cf, AspectDefinition def) throws Exception {
        Iterator methods = cf.getMethods().iterator();
        while (methods.hasNext()) {
            Annotation binfo;
            MethodInfo minfo = (MethodInfo)methods.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Bind == null ? AspectAnnotationLoader.class$("org.jboss.aop.Bind") : class$org$jboss$aop$Bind).getName())) == null) continue;
            Bind binding = (Bind)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$Bind == null ? AspectAnnotationLoader.class$("org.jboss.aop.Bind") : class$org$jboss$aop$Bind);
            String pointcutString = binding.pointcut();
            String cflow = binding.cflow();
            if (cflow == null || cflow.trim().equals("")) {
                cflow = null;
            }
            ASTCFlowExpression cflowExpression = null;
            if (cflow != null) {
                cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
            }
            AdviceFactory factory = new AdviceFactory(def, minfo.getName());
            this.manager.addInterceptorFactory(factory.getName(), factory);
            InterceptorFactory[] fact = new InterceptorFactory[]{factory};
            String name = this.getAspectMethodBindingName(cf, minfo);
            PointcutExpression pointcut = new PointcutExpression(name, pointcutString);
            AdviceBinding abinding = new AdviceBinding(name, pointcut, cflowExpression, cflow, fact);
            this.manager.addBinding(abinding);
        }
    }

    private void undeployAspectMethodBindings(ClassFile cf) throws Exception {
        Iterator methods = cf.getMethods().iterator();
        while (methods.hasNext()) {
            Annotation binfo;
            MethodInfo minfo = (MethodInfo)methods.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Bind == null ? AspectAnnotationLoader.class$("org.jboss.aop.Bind") : class$org$jboss$aop$Bind).getName())) == null) continue;
            String adviceName = cf.getName() + "." + minfo.getName();
            this.manager.removeInterceptorFactory(adviceName);
            String name = this.getAspectMethodBindingName(cf, minfo);
            this.manager.removePointcut(name);
            this.manager.removeBinding(name);
        }
    }

    private String getAspectMethodBindingName(ClassFile cf, MethodInfo minfo) throws Exception {
        String method = cf.getName() + "." + minfo.getName();
        String fullMethod = method + minfo.getDescriptor();
        return method + " " + MethodHashing.createHash(fullMethod);
    }

    private void deployInterceptorBindings(AnnotationsAttribute visible, ClassFile cf, InterceptorFactory factory) throws Exception {
        Annotation binfo = visible.getAnnotation(Bind.class.getName());
        if (binfo == null) {
            return;
        }
        Bind bind = (Bind)AnnotationProxy.createProxy(binfo, Bind.class);
        String pointcutString = bind.pointcut();
        String cflow = bind.cflow();
        if (cflow == null || cflow.trim().equals("")) {
            cflow = null;
        }
        ASTCFlowExpression cflowExpression = null;
        if (cflow != null) {
            cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
        }
        String name = cf.getName();
        InterceptorFactory[] inters = new InterceptorFactory[]{factory};
        PointcutExpression p = null;
        p = new PointcutExpression(name, pointcutString);
        AdviceBinding binding = new AdviceBinding(name, p, cflowExpression, cflow, inters);
        this.manager.addBinding(binding);
    }

    private void undeployInterceptorBindings(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation binfo = visible.getAnnotation(Bind.class.getName());
        if (binfo == null) {
            return;
        }
        String name = cf.getName();
        this.manager.removePointcut(name);
        this.manager.removeBinding(name);
    }

    private void deployPointcuts(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$PointcutDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.PointcutDef") : class$org$jboss$aop$PointcutDef).getName())) == null) continue;
            PointcutDef pdef = (PointcutDef)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$PointcutDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.PointcutDef") : class$org$jboss$aop$PointcutDef);
            PointcutExpression pointcut = new PointcutExpression(this.getPointcutName(cf, finfo), pdef.value());
            this.manager.addPointcut(pointcut);
        }
    }

    private void undeployPointcuts(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$PointcutDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.PointcutDef") : class$org$jboss$aop$PointcutDef).getName())) == null) continue;
            this.manager.removePointcut(this.getPointcutName(cf, finfo));
        }
    }

    private String getPointcutName(ClassFile cf, FieldInfo finfo) {
        return cf.getName() + "." + finfo.getName();
    }

    private void deployMixins(ClassFile cf) throws Exception {
        Iterator methods = cf.getMethods().iterator();
        while (methods.hasNext()) {
            Annotation binfo;
            MethodInfo minfo = (MethodInfo)methods.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Mixin == null ? AspectAnnotationLoader.class$("org.jboss.aop.Mixin") : class$org$jboss$aop$Mixin).getName())) == null) continue;
            MemberValue mv = binfo.getMemberValue("target");
            String target = mv != null ? ((ClassMemberValue)mv).getValue() : "java.lang.Class";
            mv = binfo.getMemberValue("typeExpression");
            String typeExpression = mv != null ? ((StringMemberValue)mv).getValue() : "";
            mv = binfo.getMemberValue("interfaces");
            MemberValue[] values = ((ArrayMemberValue)mv).getValue();
            String[] interfaces = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                interfaces[i] = ((ClassMemberValue)values[i]).getValue();
            }
            mv = binfo.getMemberValue("isTransient");
            boolean isTransient = mv != null ? ((BooleanMemberValue)mv).getValue() : true;
            String name = cf.getName() + "." + minfo.getName();
            InterfaceIntroduction intro = this.createIntroduction(name, target, typeExpression, null);
            String construction = name + "(this)";
            String classname = this.getReturnType(minfo);
            intro.getMixins().add(new InterfaceIntroduction.Mixin(classname, interfaces, construction, isTransient));
            this.manager.addInterfaceIntroduction(intro);
        }
    }

    private void undeployMixins(ClassFile cf) throws Exception {
        Iterator methods = cf.getMethods().iterator();
        while (methods.hasNext()) {
            Annotation binfo;
            MethodInfo minfo = (MethodInfo)methods.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Mixin == null ? AspectAnnotationLoader.class$("org.jboss.aop.Mixin") : class$org$jboss$aop$Mixin).getName())) == null) continue;
            String name = cf.getName() + "." + minfo.getName();
            this.manager.removeInterfaceIntroduction(name);
        }
    }

    private void deployIntroductions(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Introduction == null ? AspectAnnotationLoader.class$("org.jboss.aop.Introduction") : class$org$jboss$aop$Introduction).getName())) == null) continue;
            MemberValue mv = binfo.getMemberValue("target");
            String target = mv != null ? ((ClassMemberValue)mv).getValue() : "java.lang.Class";
            mv = binfo.getMemberValue("typeExpression");
            String typeExpression = mv != null ? ((StringMemberValue)mv).getValue() : "";
            mv = binfo.getMemberValue("interfaces");
            MemberValue[] values = ((ArrayMemberValue)mv).getValue();
            String[] interfaces = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                interfaces[i] = ((ClassMemberValue)values[i]).getValue();
            }
            String name = cf.getName() + "." + finfo.getName();
            InterfaceIntroduction interfaceIntro = this.createIntroduction(name, target, typeExpression, interfaces);
            this.manager.addInterfaceIntroduction(interfaceIntro);
        }
    }

    private void undeployIntroductions(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Introduction == null ? AspectAnnotationLoader.class$("org.jboss.aop.Introduction") : class$org$jboss$aop$Introduction).getName())) == null) continue;
            String name = cf.getName() + "." + finfo.getName();
            this.manager.removeInterfaceIntroduction(name);
        }
    }

    private void deployTypedefs(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$TypeDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.TypeDef") : class$org$jboss$aop$TypeDef).getName())) == null) continue;
            TypeDef typeDefinition = (TypeDef)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$TypeDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.TypeDef") : class$org$jboss$aop$TypeDef);
            String name = this.getTypedefName(cf, finfo);
            String expr = typeDefinition.value();
            TypedefExpression typedef = new TypedefExpression(name, expr);
            this.manager.addTypedef(typedef);
        }
    }

    private void undeployTypedefs(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$TypeDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.TypeDef") : class$org$jboss$aop$TypeDef).getName())) == null) continue;
            AnnotationProxy.createProxy(binfo, class$org$jboss$aop$TypeDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.TypeDef") : class$org$jboss$aop$TypeDef);
            this.manager.removeTypedef(this.getTypedefName(cf, finfo));
        }
    }

    private String getTypedefName(ClassFile cf, FieldInfo finfo) {
        return cf.getName() + "." + finfo.getName();
    }

    private void deployCFlowStackDefs(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$CFlowStackDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.CFlowStackDef") : class$org$jboss$aop$CFlowStackDef).getName())) == null) continue;
            CFlowStackDef stackDef = (CFlowStackDef)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$CFlowStackDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.CFlowStackDef") : class$org$jboss$aop$CFlowStackDef);
            String name = this.getStackDefName(cf, finfo);
            CFlowDef[] cflows = stackDef.cflows();
            CFlowStack stack = new CFlowStack(name);
            for (int i = 0; i < cflows.length; ++i) {
                CFlowDef cflow = cflows[i];
                boolean not = !cflow.called();
                stack.addCFlow(new CFlow(cflow.expr(), not));
            }
            this.manager.addCFlowStack(stack);
        }
    }

    private void undeployCFlowStackDefs(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$CFlowStackDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.CFlowStackDef") : class$org$jboss$aop$CFlowStackDef).getName())) == null) continue;
            AnnotationProxy.createProxy(binfo, class$org$jboss$aop$CFlowStackDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.CFlowStackDef") : class$org$jboss$aop$CFlowStackDef);
            this.manager.removeCFlowStack(this.getStackDefName(cf, finfo));
        }
    }

    private String getStackDefName(ClassFile cf, FieldInfo finfo) {
        return cf.getName() + "." + finfo.getName();
    }

    private void deployPrepares(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Prepare == null ? AspectAnnotationLoader.class$("org.jboss.aop.Prepare") : class$org$jboss$aop$Prepare).getName())) == null) continue;
            Prepare prepare = (Prepare)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$Prepare == null ? AspectAnnotationLoader.class$("org.jboss.aop.Prepare") : class$org$jboss$aop$Prepare);
            String name = this.getPrepareName(cf, finfo);
            String expr = prepare.value();
            PointcutExpression p = new PointcutExpression(name, expr);
            this.manager.addPointcut(p);
        }
    }

    private void undeployPrepares(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Prepare == null ? AspectAnnotationLoader.class$("org.jboss.aop.Prepare") : class$org$jboss$aop$Prepare).getName())) == null) continue;
            AnnotationProxy.createProxy(binfo, class$org$jboss$aop$Prepare == null ? AspectAnnotationLoader.class$("org.jboss.aop.Prepare") : class$org$jboss$aop$Prepare);
            this.manager.removePointcut(this.getPrepareName(cf, finfo));
        }
    }

    private String getPrepareName(ClassFile cf, FieldInfo finfo) {
        return cf.getName() + "." + finfo.getName();
    }

    private void deployAnnotationIntroductions(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$AnnotationIntroductionDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.AnnotationIntroductionDef") : class$org$jboss$aop$AnnotationIntroductionDef).getName())) == null) continue;
            AnnotationIntroductionDef intro = (AnnotationIntroductionDef)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$AnnotationIntroductionDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.AnnotationIntroductionDef") : class$org$jboss$aop$AnnotationIntroductionDef);
            String expr = intro.expr();
            boolean invisible = intro.invisible();
            String annotation = intro.annotation();
            annotation = annotation.replace('\'', '\"');
            AnnotationIntroduction annIntro = AnnotationIntroduction.createComplexAnnotationIntroduction(expr, annotation, invisible);
            this.manager.addAnnotationIntroduction(annIntro);
        }
    }

    private void undeployAnnotationIntroductions(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$AnnotationIntroductionDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.AnnotationIntroductionDef") : class$org$jboss$aop$AnnotationIntroductionDef).getName())) == null) continue;
            AnnotationIntroductionDef intro = (AnnotationIntroductionDef)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$AnnotationIntroductionDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.AnnotationIntroductionDef") : class$org$jboss$aop$AnnotationIntroductionDef);
            String expr = intro.expr();
            boolean invisible = intro.invisible();
            String annotation = intro.annotation();
            annotation = annotation.replace('\'', '\"');
            AnnotationIntroduction annIntro = AnnotationIntroduction.createComplexAnnotationIntroduction(expr, annotation, invisible);
            this.manager.removeAnnotationIntroduction(annIntro);
        }
    }

    private void deployDeclares(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null) continue;
            Annotation dwinfo = mgroup.getAnnotation((class$org$jboss$aop$DeclareWarning == null ? AspectAnnotationLoader.class$("org.jboss.aop.DeclareWarning") : class$org$jboss$aop$DeclareWarning).getName());
            Annotation deinfo = mgroup.getAnnotation((class$org$jboss$aop$DeclareError == null ? AspectAnnotationLoader.class$("org.jboss.aop.DeclareError") : class$org$jboss$aop$DeclareError).getName());
            if (dwinfo == null && deinfo == null) continue;
            String name = this.getDeclareName(cf, finfo);
            if (dwinfo != null && deinfo != null) {
                throw new RuntimeException("Cannot annotate " + name + " field with both DeclareError and DeclareWarning");
            }
            String expr = null;
            String msg = null;
            boolean warning = false;
            if (deinfo != null) {
                DeclareError derror = (DeclareError)AnnotationProxy.createProxy(deinfo, class$org$jboss$aop$DeclareError == null ? AspectAnnotationLoader.class$("org.jboss.aop.DeclareError") : class$org$jboss$aop$DeclareError);
                expr = derror.expr();
                msg = derror.msg();
            } else {
                DeclareWarning dwarning = (DeclareWarning)AnnotationProxy.createProxy(dwinfo, class$org$jboss$aop$DeclareWarning == null ? AspectAnnotationLoader.class$("org.jboss.aop.DeclareWarning") : class$org$jboss$aop$DeclareWarning);
                expr = dwarning.expr();
                msg = dwarning.msg();
                warning = true;
            }
            DeclareDef def = new DeclareDef(name, expr, warning, msg);
            this.manager.addDeclare(def);
        }
    }

    private String getDeclareName(ClassFile cf, FieldInfo finfo) {
        return cf.getName() + "." + finfo.getName();
    }

    private InterfaceIntroduction createIntroduction(String name, String target, String typeExpression, String[] interfaces) throws Exception {
        if (typeExpression != null && typeExpression.trim().equals("")) {
            typeExpression = null;
        }
        if (typeExpression != null && target != null && target.equals("java.lang.Class")) {
            target = null;
        }
        if (target == null && typeExpression == null) {
            throw new RuntimeException("No target nor a typeExpression attribute is defined for this @Mixin");
        }
        if (target == null && typeExpression == null) {
            throw new RuntimeException("You cannot define both a target and typeExpression attribute in the same @Mixin");
        }
        InterfaceIntroduction intro = null;
        if (target != null) {
            intro = new InterfaceIntroduction(name, target, interfaces);
        } else {
            ASTStart start = new TypeExpressionParser(new StringReader(typeExpression)).Start();
            intro = new InterfaceIntroduction(name, start, interfaces);
        }
        return intro;
    }

    private String getReturnType(MethodInfo minfo) {
        String descriptor = minfo.getDescriptor();
        int paramsEnd = descriptor.indexOf(";)");
        String classname = descriptor.substring(paramsEnd + 3, descriptor.length() - 1);
        classname = classname.replace('/', '.');
        return classname;
    }

    private String getFieldType(FieldInfo finfo) {
        String descriptor = finfo.getDescriptor();
        String classname = descriptor.substring(1, descriptor.length() - 1);
        classname = classname.replace('/', '.');
        return classname;
    }

    private static String replaceThisInExpr(String expr, String classname) {
        String THIS = "this";
        StringBuffer buf = new StringBuffer();
        int index = expr.indexOf("this");
        if (index == -1) {
            return expr;
        }
        int lastindex = 0;
        while (index != -1) {
            boolean isPartOfWord = false;
            if (index > 0) {
                char before = expr.charAt(index - 1);
                isPartOfWord = Character.isJavaIdentifierPart(before);
            }
            if (!isPartOfWord && index + "this".length() < expr.length() - 1) {
                char after = expr.charAt(index + "this".length());
                isPartOfWord = Character.isJavaIdentifierPart(after);
            }
            buf.append(expr.substring(lastindex, index));
            if (isPartOfWord) {
                buf.append("this");
            } else {
                buf.append(classname);
            }
            lastindex = index + "this".length();
            index = expr.indexOf("this", lastindex);
        }
        buf.append(expr.substring(lastindex));
        return buf.toString();
    }
}

