/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.csv.CsvParser;
import org.dbunit.dataset.csv.CsvParserException;
import org.dbunit.dataset.csv.IllegalInputCharacterException;
import org.dbunit.dataset.csv.handlers.EscapeHandler;
import org.dbunit.dataset.csv.handlers.IsAlnumHandler;
import org.dbunit.dataset.csv.handlers.Pipeline;
import org.dbunit.dataset.csv.handlers.PipelineException;
import org.dbunit.dataset.csv.handlers.QuoteHandler;
import org.dbunit.dataset.csv.handlers.SeparatorHandler;
import org.dbunit.dataset.csv.handlers.TransparentHandler;
import org.dbunit.dataset.csv.handlers.WhitespacesHandler;

public class CsvParserImpl
implements CsvParser {
    private Pipeline pipeline;

    public CsvParserImpl() {
        this.resetThePipeline();
    }

    private void resetThePipeline() {
        this.pipeline = new Pipeline();
        this.getPipeline().putFront(SeparatorHandler.ENDPIECE());
        this.getPipeline().putFront(EscapeHandler.ACCEPT());
        this.getPipeline().putFront(IsAlnumHandler.QUOTE());
        this.getPipeline().putFront(QuoteHandler.QUOTE());
        this.getPipeline().putFront(EscapeHandler.ESCAPE());
        this.getPipeline().putFront(WhitespacesHandler.IGNORE());
        this.getPipeline().putFront(TransparentHandler.IGNORE());
    }

    public List parse(String csv) throws PipelineException, IllegalInputCharacterException {
        this.getPipeline().resetProducts();
        StringCharacterIterator iterator = new StringCharacterIterator(csv);
        char c = iterator.first();
        while (c != '\uffff') {
            this.getPipeline().handle(c);
            c = iterator.next();
        }
        this.getPipeline().noMoreInput();
        this.getPipeline().thePieceIsDone();
        return this.getPipeline().getProducts();
    }

    public List parse(File file) throws IOException, CsvParserException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        return this.parse(reader, file.getAbsolutePath().toString());
    }

    public List parse(URL url) throws IOException, CsvParserException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        return this.parse(reader, url.toString());
    }

    public List parse(Reader reader, String source) throws IOException, CsvParserException {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        ArrayList rows = new ArrayList();
        List columnsInFirstLine = this.parseFirstLine(lineNumberReader, source, rows);
        this.parseTheData(columnsInFirstLine, lineNumberReader, rows);
        return rows;
    }

    private List parseFirstLine(LineNumberReader lineNumberReader, File file, List rows) throws IOException, CsvParserException {
        return this.parseFirstLine(lineNumberReader, file.getAbsolutePath().toString(), rows);
    }

    private List parseFirstLine(LineNumberReader lineNumberReader, String source, List rows) throws IOException, CsvParserException {
        String firstLine = lineNumberReader.readLine();
        if (firstLine == null) {
            throw new CsvParserException("The first line of " + source + " is null");
        }
        List columnsInFirstLine = this.parse(firstLine);
        rows.add(columnsInFirstLine);
        return columnsInFirstLine;
    }

    private void parseTheData(List columnsInFirstLine, LineNumberReader lineNumberReader, List rows) throws IOException, CsvParserException {
        List columns;
        int nColumns = columnsInFirstLine.size();
        while ((columns = this.collectExpectedNumberOfColumns(nColumns, lineNumberReader)) != null) {
            rows.add(columns);
        }
    }

    private List collectExpectedNumberOfColumns(int expectedNumberOfColumns, LineNumberReader lineNumberReader) throws IOException, CsvParserException {
        List columns = null;
        int columnsCollectedSoFar = 0;
        StringBuffer buffer = new StringBuffer();
        String anotherLine = lineNumberReader.readLine();
        if (anotherLine == null) {
            return null;
        }
        boolean shouldProceed = false;
        while (columnsCollectedSoFar < expectedNumberOfColumns) {
            try {
                buffer.append(anotherLine);
                columns = this.parse(buffer.toString());
                columnsCollectedSoFar = columns.size();
            }
            catch (IllegalStateException e) {
                this.resetThePipeline();
                anotherLine = lineNumberReader.readLine();
                if (anotherLine == null) break;
                buffer.append("\n");
                shouldProceed = true;
            }
            if (shouldProceed) continue;
        }
        if (columnsCollectedSoFar != expectedNumberOfColumns) {
            String message = "Expected " + expectedNumberOfColumns + " columns on line " + lineNumberReader.getLineNumber() + ", got " + columnsCollectedSoFar + ". Offending line: " + buffer;
            throw new CsvParserException(message);
        }
        return columns;
    }

    Pipeline getPipeline() {
        return this.pipeline;
    }

    void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }
}

