/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import junit.framework.TestCase;
import org.dbunit.DefaultDatabaseTester;
import org.dbunit.IDatabaseTester;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;

public abstract class DatabaseTestCase
extends TestCase {
    private IDatabaseTester tester;

    public DatabaseTestCase() {
    }

    public DatabaseTestCase(String name) {
        super(name);
    }

    protected abstract IDatabaseConnection getConnection() throws Exception;

    protected abstract IDataSet getDataSet() throws Exception;

    protected IDatabaseTester newDatabaseTester() throws Exception {
        IDatabaseConnection connection = this.getConnection();
        DefaultDatabaseTester tester = new DefaultDatabaseTester(connection);
        return tester;
    }

    protected IDatabaseTester getDatabaseTester() throws Exception {
        if (this.tester == null) {
            this.tester = this.newDatabaseTester();
        }
        return this.tester;
    }

    protected void closeConnection(IDatabaseConnection connection) throws Exception {
        DatabaseTestCase.assertNotNull((String)"DatabaseTester is not set", (Object)this.getDatabaseTester());
        this.getDatabaseTester().closeConnection(connection);
    }

    protected DatabaseOperation getSetUpOperation() throws Exception {
        return DatabaseOperation.CLEAN_INSERT;
    }

    protected DatabaseOperation getTearDownOperation() throws Exception {
        return DatabaseOperation.NONE;
    }

    protected void setUp() throws Exception {
        super.setUp();
        IDatabaseTester databaseTester = this.getDatabaseTester();
        DatabaseTestCase.assertNotNull((String)"DatabaseTester is not set", (Object)databaseTester);
        databaseTester.setSetUpOperation(this.getSetUpOperation());
        databaseTester.setDataSet(this.getDataSet());
        databaseTester.onSetup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            IDatabaseTester databaseTester = this.getDatabaseTester();
            DatabaseTestCase.assertNotNull((String)"DatabaseTester is not set", (Object)databaseTester);
            databaseTester.setTearDownOperation(this.getTearDownOperation());
            databaseTester.setDataSet(this.getDataSet());
            databaseTester.onTearDown();
        }
        finally {
            super.tearDown();
        }
    }
}

