/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.pojo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hibernate.cfg.Configuration;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.pojo.BasicPOJOClass;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.hibernate.tool.hbm2x.pojo.SkipBackRefPropertyIterator;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.StringHelper;

public class EntityPOJOClass
extends BasicPOJOClass {
    private PersistentClass clazz;

    public EntityPOJOClass(PersistentClass clazz, Cfg2JavaTool cfg) {
        super((MetaAttributable)clazz, cfg);
        this.clazz = clazz;
        this.init();
    }

    protected String getMappedClassName() {
        return this.clazz.getClassName();
    }

    public String getExtends() {
        String extendz = "";
        if (this.isInterface()) {
            if (this.clazz.getSuperclass() != null) {
                extendz = this.clazz.getSuperclass().getClassName();
            }
            if (this.clazz.getMetaAttribute("extends") != null) {
                if (!"".equals(extendz)) {
                    extendz = extendz + ",";
                }
                extendz = extendz + this.getMetaAsString("extends", ",");
            }
        } else if (this.clazz.getSuperclass() != null) {
            if (!this.c2j.getPOJOClass(this.clazz.getSuperclass()).isInterface()) {
                extendz = this.clazz.getSuperclass().getClassName();
            }
        } else if (this.clazz.getMetaAttribute("extends") != null) {
            extendz = this.getMetaAsString("extends", ",");
        }
        return "".equals(extendz) ? null : extendz;
    }

    public String getImplements() {
        ArrayList<String> interfaces = new ArrayList<String>();
        if (this.clazz.getProxyInterfaceName() != null && !this.clazz.getProxyInterfaceName().equals(this.clazz.getClassName())) {
            interfaces.add(this.clazz.getProxyInterfaceName());
        }
        if (!this.isInterface()) {
            if (this.clazz.getSuperclass() != null && this.c2j.getPOJOClass(this.clazz.getSuperclass()).isInterface()) {
                interfaces.add(this.clazz.getSuperclass().getClassName());
            }
            if (this.clazz.getMetaAttribute("implements") != null) {
                interfaces.addAll(this.clazz.getMetaAttribute("implements").getValues());
            }
            interfaces.add(Serializable.class.getName());
        }
        if (interfaces.size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            Iterator iter = interfaces.iterator();
            while (iter.hasNext()) {
                sbuf.append(iter.next());
                if (!iter.hasNext()) continue;
                sbuf.append(",");
            }
            return sbuf.toString();
        }
        return null;
    }

    public Iterator getAllPropertiesIterator() {
        return this.getAllPropertiesIterator(this.clazz);
    }

    public Iterator getAllPropertiesIterator(PersistentClass pc) {
        ArrayList<Property> properties = new ArrayList<Property>();
        ArrayList<Iterator> iterators = new ArrayList<Iterator>();
        if (pc.getSuperclass() == null) {
            if (pc.hasIdentifierProperty()) {
                properties.add(pc.getIdentifierProperty());
            } else if (pc.hasEmbeddedIdentifier()) {
                Component embeddedComponent = (Component)pc.getIdentifier();
                iterators.add(embeddedComponent.getPropertyIterator());
            }
        }
        iterators.add(properties.iterator());
        iterators.add(pc.getPropertyIterator());
        Iterator[] it = iterators.toArray(new Iterator[iterators.size()]);
        return new SkipBackRefPropertyIterator((Iterator)new JoinedIterator(it));
    }

    public boolean isComponent() {
        return false;
    }

    public boolean hasIdentifierProperty() {
        return this.clazz.hasIdentifierProperty();
    }

    public Property getIdentifierProperty() {
        return this.clazz.getIdentifierProperty();
    }

    public boolean needsAnnTableUniqueConstraints() {
        return !(this.clazz instanceof Subclass) && this.clazz.getTable().getUniqueKeyIterator().hasNext();
    }

    public String generateAnnTableUniqueConstraint() {
        if (!(this.clazz instanceof Subclass)) {
            Table table = this.clazz.getTable();
            return this.generateAnnTableUniqueConstraint(table);
        }
        return "";
    }

    private String generateAnnTableUniqueConstraint(Table table) {
        StringBuffer constraints = new StringBuffer();
        Iterator uniqueKeys = table.getUniqueKeyIterator();
        while (uniqueKeys.hasNext()) {
            UniqueKey key = (UniqueKey)uniqueKeys.next();
            if (table.hasPrimaryKey() && ((Object)table.getPrimaryKey().getColumns()).equals(key.getColumns())) continue;
            String constraint = this.importType("javax.persistence.UniqueConstraint");
            constraints.append("@" + constraint + "( columnNames = { ");
            Iterator columns = key.getColumnIterator();
            while (columns.hasNext()) {
                constraints.append("\"" + ((Column)columns.next()).getName() + "\"").append(", ");
            }
            constraints.setLength(constraints.length() - 2);
            constraints.append(" } ), ");
        }
        if (constraints.length() != 0) {
            constraints.setLength(constraints.length() - 2);
        }
        return constraints.toString();
    }

    public String generateAnnIdGenerator() {
        KeyValue identifier = this.clazz.getIdentifier();
        String strategy = null;
        Properties properties = null;
        StringBuffer wholeString = new StringBuffer("    ");
        if (identifier instanceof Component) {
            wholeString.append("@" + this.importType("javax.persistence.EmbeddedId"));
        } else if (identifier instanceof SimpleValue) {
            SimpleValue simpleValue = (SimpleValue)identifier;
            strategy = simpleValue.getIdentifierGeneratorStrategy();
            properties = simpleValue.getIdentifierGeneratorProperties();
            StringBuffer id = new StringBuffer().append("@").append(this.importType("javax.persistence.Id"));
            boolean isGenericGenerator = false;
            if (!"assigned".equals(strategy)) {
                id.append(" @").append(this.importType("javax.persistence.GeneratedValue"));
                if (!"native".equals(strategy)) {
                    id.append('(');
                    if ("identity".equals(strategy)) {
                        id.append("strategy=");
                        id.append(this.staticImport("javax.persistence.GenerationType", "IDENTITY"));
                    } else if ("sequence".equals(strategy)) {
                        id.append("strategy=");
                        id.append(this.staticImport("javax.persistence.GenerationType", "SEQUENCE")).append(", generator=\"generator\"");
                        this.buildAnnSequenceGenerator(wholeString, properties);
                    } else if (MultipleHiLoPerTableGenerator.class.getName().equals(strategy)) {
                        id.append("strategy=");
                        id.append(this.staticImport("javax.persistence.GenerationType", "TABLE")).append(", generator=\"generator\"");
                        this.buildAnnTableGenerator(wholeString, properties);
                    } else {
                        isGenericGenerator = true;
                        id.append("generator=\"generator\"");
                    }
                    id.append(')');
                }
            }
            if (isGenericGenerator) {
                wholeString.append("@" + this.importType("org.hibernate.annotations.GenericGenerator")).append("(name=\"generator\", strategy=\"").append(strategy).append("\", ");
                wholeString.append("parameters = {  ");
                if (properties != null) {
                    Enumeration<?> propNames = properties.propertyNames();
                    while (propNames.hasMoreElements()) {
                        String propertyName = (String)propNames.nextElement();
                        wholeString.append("@" + this.importType("org.hibernate.annotations.Parameter")).append("(name=\"").append(propertyName).append("\", ").append("value=\"").append(properties.getProperty(propertyName)).append("\"), ");
                    }
                }
                wholeString.setLength(wholeString.length() - 2);
                wholeString.append(" } )\n");
            }
            wholeString.append(id);
        }
        return wholeString.toString();
    }

    private void buildAnnSequenceGenerator(StringBuffer wholeString, Properties properties) {
        wholeString.append("@" + this.importType("javax.persistence.SequenceGenerator") + "(name=\"generator\", sequenceName=\"").append(properties.getProperty("sequence", "")).append("\")");
        wholeString.append("\n    ");
    }

    private void buildAnnTableGenerator(StringBuffer wholeString, Properties properties) {
        wholeString.append("@" + this.importType("javax.persistence.TableGenerator") + "(name=\"generator\", table=\"").append(properties.getProperty("generatorTableName", "hibernate_sequences")).append("\"");
        if (!this.isPropertyDefault("catalog", properties)) {
            wholeString.append(", catalog=\"").append(properties.getProperty("catalog", ""));
        }
        if (!this.isPropertyDefault("schema", properties)) {
            wholeString.append(", schema=\"").append(properties.getProperty("schema", ""));
        }
        if (!this.isPropertyDefault("primary_key_value", properties)) {
            wholeString.append(", pkColumnValue=\"").append(properties.getProperty("primary_key_value", "")).append("\"");
        }
        if (!this.isPropertyDefault("max_lo", properties, "50")) {
            wholeString.append(", allocationSize=").append(properties.getProperty("max_lo", "50"));
        }
        if (!this.isPropertyDefault("primary_key_column", properties)) {
            wholeString.append(", pkColumnName=\"").append(properties.getProperty("primary_key_column", "")).append("\"");
        }
        if (!this.isPropertyDefault("value_column", properties)) {
            wholeString.append(", valueColumnName=\"").append(properties.getProperty("value_column", "")).append("\"");
        }
        wholeString.append(")\n    ");
    }

    private boolean isPropertyDefault(String property, Properties properties) {
        return StringHelper.isEmpty((String)properties.getProperty(property));
    }

    private boolean isPropertyDefault(String property, Properties properties, String defaultValue) {
        String propertyValue = properties.getProperty(property);
        return propertyValue != null && propertyValue.equals(defaultValue);
    }

    public String generateJoinColumnsAnnotation(Property property) {
        Iterator columnIterator;
        int span;
        boolean insertable = property.isInsertable();
        boolean updatable = property.isUpdateable();
        Value value = property.getValue();
        if (value != null && value instanceof Collection) {
            Collection collection = (Collection)value;
            span = collection.getKey().getColumnSpan();
            columnIterator = collection.getKey().getColumnIterator();
        } else {
            span = property.getColumnSpan();
            columnIterator = property.getColumnIterator();
        }
        StringBuffer annotations = new StringBuffer("    ");
        if (span == 1) {
            Selectable selectable = (Selectable)columnIterator.next();
            this.buildJoinColumnAnnotation(selectable, annotations, insertable, updatable);
        } else {
            Iterator columns = columnIterator;
            annotations.append("@").append(this.importType("javax.persistence.JoinColumns")).append("( { ");
            this.buildArrayOfJoinColumnAnnotation(columns, annotations, insertable, updatable);
            annotations.append(" } )");
        }
        return annotations.toString();
    }

    private void buildArrayOfJoinColumnAnnotation(Iterator columns, StringBuffer annotations, boolean insertable, boolean updatable) {
        while (columns.hasNext()) {
            Selectable selectable = (Selectable)columns.next();
            if (selectable.isFormula()) continue;
            annotations.append("\n        ");
            this.buildJoinColumnAnnotation(selectable, annotations, insertable, updatable);
            annotations.append(", ");
        }
        annotations.setLength(annotations.length() - 2);
    }

    private void buildJoinColumnAnnotation(Selectable selectable, StringBuffer annotations, boolean insertable, boolean updatable) {
        if (!selectable.isFormula()) {
            Column column = (Column)selectable;
            annotations.append("@").append(this.importType("javax.persistence.JoinColumn")).append("(name=\"").append(column.getName()).append("\"").append(", unique=").append(column.isUnique()).append(", nullable=").append(column.isNullable()).append(", insertable=").append(insertable).append(", updatable=").append(updatable);
            String sqlType = column.getSqlType();
            if (StringHelper.isNotEmpty((String)sqlType)) {
                annotations.append(", columnDefinition=\"").append(sqlType).append("\"");
            }
            annotations.append(")");
        }
    }

    public String getCascadeType(Property property) {
        StringTokenizer st = new StringTokenizer(property.getCascade(), ", ", false);
        String cascadeType = null;
        StringBuffer cascade = new StringBuffer();
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).toLowerCase();
            if ("persist".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("javax.persistence.CascadeType");
                }
                cascade.append(cascadeType).append(".PERSIST").append(", ");
                continue;
            }
            if ("merge".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("javax.persistence.CascadeType");
                }
                cascade.append(cascadeType).append(".MERGE").append(", ");
                continue;
            }
            if ("delete".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("javax.persistence.CascadeType");
                }
                cascade.append(cascadeType).append(".REMOVE").append(", ");
                continue;
            }
            if ("refresh".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("javax.persistence.CascadeType");
                }
                cascade.append(cascadeType).append(".REFRESH").append(", ");
                continue;
            }
            if (!"all".equals(element)) continue;
            if (cascadeType == null) {
                cascadeType = this.importType("javax.persistence.CascadeType");
            }
            cascade.append(cascadeType).append(".ALL").append(", ");
        }
        if (cascade.length() >= 2) {
            cascade.setLength(cascade.length() - 2);
        }
        return cascade.toString();
    }

    public String getHibernateCascadeTypeAnnotation(Property property) {
        StringTokenizer st = new StringTokenizer(property.getCascade(), ", ", false);
        String cascadeType = null;
        StringBuffer cascade = new StringBuffer();
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).toLowerCase();
            if ("all-delete-orphan".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".ALL").append(", ").append(cascadeType).append(".DELETE_ORPHAN").append(", ");
                continue;
            }
            if ("delete-orphan".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".DELETE_ORPHAN").append(", ");
                continue;
            }
            if ("save-update".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".SAVE_UPDATE").append(", ");
                continue;
            }
            if ("replicate".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".REPLICATE").append(", ");
                continue;
            }
            if ("lock".equals(element)) {
                if (cascadeType == null) {
                    cascadeType = this.importType("org.hibernate.annotations.CascadeType");
                }
                cascade.append(cascadeType).append(".LOCK").append(", ");
                continue;
            }
            if (!"evict".equals(element)) continue;
            if (cascadeType == null) {
                cascadeType = this.importType("org.hibernate.annotations.CascadeType");
            }
            cascade.append(cascadeType).append(".EVICT").append(", ");
        }
        if (cascade.length() >= 2) {
            String hibernateCascade = this.importType("org.hibernate.annotations.Cascade");
            cascade.insert(0, "@" + hibernateCascade + "( {");
            cascade.setLength(cascade.length() - 2);
            cascade.append("} )");
        }
        return cascade.toString();
    }

    public String getFetchType(Property property) {
        Value value = property.getValue();
        String fetchType = this.importType("javax.persistence.FetchType");
        boolean lazy = false;
        lazy = value instanceof ToOne ? ((ToOne)value).isLazy() : (value instanceof Collection ? ((Collection)value).isLazy() : property.isLazy());
        if (lazy) {
            return fetchType + "." + "LAZY";
        }
        return fetchType + "." + "EAGER";
    }

    public Object getDecoratedObject() {
        return this.clazz;
    }

    public String generateCollectionAnnotation(Property property, Configuration cfg) {
        StringBuffer annotation = new StringBuffer();
        Value value = property.getValue();
        if (value != null && value instanceof Collection) {
            String mappedBy;
            Collection collection = (Collection)value;
            if (collection.isOneToMany()) {
                mappedBy = null;
                annotation.append("    @").append(this.importType("javax.persistence.OneToMany")).append("(cascade={").append(this.getCascadeType(property)).append("}").append(", fetch=").append(this.getFetchType(property));
                if (collection.isInverse()) {
                    annotation.append(", mappedBy=\"");
                    Iterator joinColumnsIt = collection.getKey().getColumnIterator();
                    HashSet joinColumns = new HashSet();
                    while (joinColumnsIt.hasNext()) {
                        joinColumns.add(joinColumnsIt.next());
                    }
                    OneToMany oneToMany = (OneToMany)collection.getElement();
                    PersistentClass pc = cfg.getClassMapping(oneToMany.getReferencedEntityName());
                    Iterator properties = pc.getPropertyClosureIterator();
                    boolean isOtherSide = false;
                    mappedBy = "unresolved";
                    while (!isOtherSide && properties.hasNext()) {
                        Property manyProperty = (Property)properties.next();
                        Value manyValue = manyProperty.getValue();
                        if (manyValue == null || !(manyValue instanceof ManyToOne) || joinColumns.size() != manyValue.getColumnSpan()) continue;
                        isOtherSide = true;
                        Iterator it = manyValue.getColumnIterator();
                        while (it.hasNext()) {
                            Object column = it.next();
                            if (joinColumns.contains(column)) continue;
                            isOtherSide = false;
                            break;
                        }
                        if (!isOtherSide) continue;
                        mappedBy = manyProperty.getName();
                    }
                    annotation.append(mappedBy).append("\"");
                }
                annotation.append(")");
                if (mappedBy == null) {
                    annotation.append("\n").append(this.generateJoinColumnsAnnotation(property));
                }
            } else {
                mappedBy = null;
                annotation.append("    @").append(this.importType("javax.persistence.ManyToMany")).append("(cascade={").append(this.getCascadeType(property)).append("}").append(", fetch=").append(this.getFetchType(property));
                if (collection.isInverse()) {
                    annotation.append(", mappedBy=\"");
                    Iterator joinColumnsIt = collection.getKey().getColumnIterator();
                    HashSet joinColumns = new HashSet();
                    while (joinColumnsIt.hasNext()) {
                        joinColumns.add(joinColumnsIt.next());
                    }
                    ManyToOne manyToOne = (ManyToOne)collection.getElement();
                    PersistentClass pc = cfg.getClassMapping(manyToOne.getReferencedEntityName());
                    Iterator properties = pc.getPropertyClosureIterator();
                    boolean isOtherSide = false;
                    mappedBy = "unresolved";
                    while (!isOtherSide && properties.hasNext()) {
                        Collection realCollectionValue;
                        Property collectionProperty = (Property)properties.next();
                        Value collectionValue = collectionProperty.getValue();
                        if (collectionValue == null || !(collectionValue instanceof Collection) || (realCollectionValue = (Collection)collectionValue).isOneToMany() || joinColumns.size() != realCollectionValue.getElement().getColumnSpan()) continue;
                        isOtherSide = true;
                        Iterator it = realCollectionValue.getElement().getColumnIterator();
                        while (it.hasNext()) {
                            Object column = it.next();
                            if (joinColumns.contains(column)) continue;
                            isOtherSide = false;
                            break;
                        }
                        if (!isOtherSide) continue;
                        mappedBy = collectionProperty.getName();
                    }
                    annotation.append(mappedBy).append("\"");
                }
                annotation.append(")");
                if (mappedBy == null) {
                    String uniqueConstraint;
                    annotation.append("\n    @");
                    annotation.append(this.importType("javax.persistence.JoinTable")).append("(name=\"");
                    Table table = collection.getCollectionTable();
                    annotation.append(table.getName());
                    annotation.append("\"");
                    if (StringHelper.isNotEmpty((String)table.getSchema())) {
                        annotation.append(", schema=\"").append(table.getSchema()).append("\"");
                    }
                    if (StringHelper.isNotEmpty((String)table.getCatalog())) {
                        annotation.append(", catalog=\"").append(table.getCatalog()).append("\"");
                    }
                    if ((uniqueConstraint = this.generateAnnTableUniqueConstraint(table)).length() > 0) {
                        annotation.append(", uniqueConstraints={").append(uniqueConstraint).append("}");
                    }
                    annotation.append(", joinColumns = { ");
                    this.buildArrayOfJoinColumnAnnotation(collection.getKey().getColumnIterator(), annotation, property.isInsertable(), property.isUpdateable());
                    annotation.append(" }");
                    annotation.append(", inverseJoinColumns = { ");
                    this.buildArrayOfJoinColumnAnnotation(collection.getElement().getColumnIterator(), annotation, property.isInsertable(), property.isUpdateable());
                    annotation.append(" }");
                    annotation.append(")");
                }
            }
            String hibernateCascade = this.getHibernateCascadeTypeAnnotation(property);
            if (hibernateCascade.length() > 0) {
                annotation.append("\n    ").append(hibernateCascade);
            }
        }
        return annotation.toString();
    }

    public boolean isSubclass() {
        return this.clazz.getSuperclass() != null;
    }

    public List getPropertyClosureForFullConstructor() {
        return this.getPropertyClosureForFullConstructor(this.clazz);
    }

    protected List getPropertyClosureForFullConstructor(PersistentClass pc) {
        ArrayList l = new ArrayList(this.getPropertyClosureForSuperclassFullConstructor(pc));
        l.addAll(this.getPropertiesForFullConstructor(pc));
        return l;
    }

    public List getPropertiesForFullConstructor() {
        return this.getPropertiesForFullConstructor(this.clazz);
    }

    protected List getPropertiesForFullConstructor(PersistentClass pc) {
        ArrayList<Property> result = new ArrayList<Property>();
        Iterator myFields = this.getAllPropertiesIterator(pc);
        while (myFields.hasNext()) {
            Property field = (Property)myFields.next();
            if (field.equals(pc.getIdentifierProperty()) && !this.isAssignedIdentifier(pc, field) || field.equals(pc.getVersion()) || field.isBackRef() || this.isFormula(field)) continue;
            result.add(field);
        }
        return result;
    }

    private boolean isFormula(Property field) {
        Value value = field.getValue();
        boolean foundFormula = false;
        if (value != null && value.getColumnSpan() > 0) {
            Iterator columnIterator = value.getColumnIterator();
            while (columnIterator.hasNext()) {
                Selectable element = (Selectable)columnIterator.next();
                if (!(element instanceof Formula)) {
                    return false;
                }
                foundFormula = true;
            }
        } else {
            return false;
        }
        return foundFormula;
    }

    public List getPropertyClosureForSuperclassFullConstructor() {
        return this.getPropertyClosureForSuperclassFullConstructor(this.clazz);
    }

    public List getPropertyClosureForSuperclassFullConstructor(PersistentClass pc) {
        ArrayList result = new ArrayList();
        if (pc.getSuperclass() != null) {
            result.addAll(this.getPropertyClosureForSuperclassFullConstructor(pc.getSuperclass()));
            result.addAll(this.getPropertiesForFullConstructor(pc.getSuperclass()));
        }
        return result;
    }

    public List getPropertyClosureForMinimalConstructor() {
        return this.getPropertyClosureForMinimalConstructor(this.clazz);
    }

    protected List getPropertyClosureForMinimalConstructor(PersistentClass pc) {
        ArrayList l = new ArrayList(this.getPropertyClosureForSuperclassMinConstructor(pc));
        l.addAll(this.getPropertiesForMinimalConstructor(pc));
        return l;
    }

    public List getPropertiesForMinimalConstructor() {
        return this.getPropertiesForMinimalConstructor(this.clazz);
    }

    protected List getPropertiesForMinimalConstructor(PersistentClass pc) {
        ArrayList<Property> result = new ArrayList<Property>();
        Iterator myFields = this.getAllPropertiesIterator(pc);
        while (myFields.hasNext()) {
            Property property = (Property)myFields.next();
            if (property.equals(pc.getIdentifierProperty())) {
                if (!this.isAssignedIdentifier(pc, property)) continue;
                result.add(property);
                continue;
            }
            if (property.equals(pc.getVersion()) || !this.isRequiredInConstructor(property)) continue;
            result.add(property);
        }
        return result;
    }

    protected boolean isAssignedIdentifier(PersistentClass pc, Property property) {
        SimpleValue sv;
        return property.equals(pc.getIdentifierProperty()) && property.getValue().isSimpleValue() && "assigned".equals((sv = (SimpleValue)property.getValue()).getIdentifierGeneratorStrategy());
    }

    public List getPropertyClosureForSuperclassMinimalConstructor() {
        return this.getPropertyClosureForSuperclassMinConstructor(this.clazz);
    }

    protected List getPropertyClosureForSuperclassMinConstructor(PersistentClass pc) {
        ArrayList result = new ArrayList();
        if (pc.getSuperclass() != null) {
            result.addAll(this.getPropertyClosureForSuperclassMinConstructor(pc.getSuperclass()));
            result.addAll(this.getPropertiesForMinimalConstructor(pc.getSuperclass()));
        }
        return result;
    }

    public POJOClass getSuperClass() {
        return new EntityPOJOClass(this.clazz.getSuperclass(), this.c2j);
    }

    public String toString() {
        return this.getClass().getName() + "(" + (this.clazz == null ? "<none>" : this.clazz.getEntityName()) + ")";
    }

    public boolean hasVersionProperty() {
        return this.clazz.isVersioned() && this.clazz instanceof RootClass;
    }
}

